/*
 * Decompiled with CFR 0.152.
 */
package driftwood.star;

import driftwood.star.DataBlock;
import driftwood.star.DataCell;
import driftwood.star.StarFile;
import driftwood.star.StarTokenizer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class StarReader {
    LineNumberReader input = null;
    StarTokenizer token = null;
    StarFile dom = null;
    double percentMemFree = 0.4;

    public StarFile parse(LineNumberReader lineNumberReader) throws IOException, ParseException {
        this.input = lineNumberReader;
        this.token = new StarTokenizer(lineNumberReader);
        this.dom = new StarFile();
        while (!this.token.isEOF()) {
            DataCell dataCell;
            if (this.token.isGlobal()) {
                dataCell = this.dom.getGlobalBlock();
                this.token.advance();
                this.doGlobal(dataCell);
                continue;
            }
            if (this.token.isData()) {
                dataCell = new DataBlock(this.token.getString());
                if (this.dom.addDataBlock((DataBlock)dataCell) != null) {
                    throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Repeated data block name: data_" + dataCell, this.input.getLineNumber() + 1);
                }
                this.token.advance();
                this.doDataBlock((DataBlock)dataCell);
                continue;
            }
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Illegal token type '" + this.token.getType() + "' at top level", this.input.getLineNumber() + 1);
        }
        return this.dom;
    }

    protected void doGlobal(DataCell dataCell) throws IOException, ParseException {
        while (!(this.token.isEOF() || this.token.isGlobal() || this.token.isData())) {
            if (this.token.isLoopStart()) {
                this.token.advance();
                this.doLoop(dataCell);
                continue;
            }
            if (this.token.isName()) {
                this.doItem(dataCell);
                continue;
            }
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Illegal token type '" + this.token.getType() + "' in global block", this.input.getLineNumber() + 1);
        }
    }

    protected void doDataBlock(DataBlock dataBlock) throws IOException, ParseException {
        while (!(this.token.isEOF() || this.token.isGlobal() || this.token.isData())) {
            if (this.token.isLoopStart()) {
                this.token.advance();
                this.doLoop(dataBlock);
                continue;
            }
            if (this.token.isName()) {
                this.doItem(dataBlock);
                continue;
            }
            if (this.token.isSaveStart()) {
                DataCell dataCell = new DataCell(this.token.getString());
                DataCell dataCell2 = dataBlock.addSaveFrame(dataCell);
                if (dataCell2 != null) {
                    dataCell = dataCell2;
                }
                this.token.advance();
                this.doSaveFrame(dataCell);
                continue;
            }
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Illegal token type '" + this.token.getType() + "' in data block", this.input.getLineNumber() + 1);
        }
    }

    protected void doSaveFrame(DataCell dataCell) throws IOException, ParseException {
        while (!this.token.isEOF() && !this.token.isSaveEnd()) {
            if (this.token.isLoopStart()) {
                this.token.advance();
                this.doLoop(dataCell);
                continue;
            }
            if (this.token.isName()) {
                this.doItem(dataCell);
                continue;
            }
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Illegal token type '" + this.token.getType() + "' in save frame", this.input.getLineNumber() + 1);
        }
        if (this.token.isSaveEnd()) {
            this.token.advance();
        }
    }

    protected void doLoop(DataCell dataCell) throws IOException, ParseException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!this.token.isEOF() && this.token.isName()) {
            arrayList.add(this.token.getString());
            this.token.advance();
        }
        if (arrayList.size() == 0) {
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "No data names declared for loop_ (0 columns)", this.input.getLineNumber() + 1);
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        long l4 = l3 + (l - l2);
        List[] listArray = new List[arrayList.size()];
        for (n = 0; n < listArray.length; ++n) {
            listArray[n] = new ArrayList();
        }
        n = 0;
        int n2 = 0;
        while (!this.token.isEOF() && !this.token.isLoopEnd() && this.token.isValue() && (double)l4 / (double)l > this.percentMemFree) {
            listArray[n2].add(this.token.getString());
            this.token.advance();
            if (++n2 % listArray.length == 0) {
                n2 = 0;
                ++n;
            }
            l2 = runtime.totalMemory();
            l3 = runtime.freeMemory();
            l4 = l3 + (l - l2);
        }
        if (!((double)l4 / (double)l > this.percentMemFree)) {
            while (n == 0 || n2 != 0) {
                listArray[n2].add(this.token.getString());
                this.token.advance();
                if (++n2 % listArray.length != 0) continue;
                n2 = 0;
                ++n;
            }
            while (!this.token.isEOF() && !this.token.isLoopEnd() && this.token.isValue()) {
                this.token.advance();
            }
            l2 = runtime.totalMemory();
            l3 = runtime.freeMemory();
            l4 = l3 + (l - l2);
            this.percentMemFree = (double)l4 / (double)l - 0.04;
        }
        if (this.token.isLoopEnd()) {
            this.token.advance();
        }
        if (n2 != 0) {
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Not enough values to complete row " + (n + 1) + " in loop_", this.input.getLineNumber() + 1);
        }
        if (n == 0) {
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "No data values declared for loop_ (0 rows)", this.input.getLineNumber() + 1);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            dataCell.putItem((String)arrayList.get(i), listArray[i]);
        }
    }

    protected void doItem(DataCell dataCell) throws IOException, ParseException {
        if (!this.token.isName()) {
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Illegal token type '" + this.token.getType() + "' when data name was expected", this.input.getLineNumber() + 1);
        }
        String string = this.token.getString();
        this.token.advance();
        if (!this.token.isValue()) {
            throw new ParseException("[line " + (this.input.getLineNumber() + 1) + "] " + "Illegal token type '" + this.token.getType() + "' when data value was expected", this.input.getLineNumber() + 1);
        }
        String string2 = this.token.getString();
        dataCell.putItem(string, string2);
        this.token.advance();
    }

    public static void main(String[] stringArray) throws IOException, ParseException {
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
        StarReader starReader = new StarReader();
        StarFile starFile = starReader.parse(lineNumberReader);
        System.out.println("Global items:");
        System.out.println(starFile.getGlobalBlock().getItemNames());
        System.out.println();
        System.out.println("Data blocks:");
        System.out.println(starFile.getDataBlockNames());
        System.out.println();
        for (String string : starFile.getDataBlockNames()) {
            DataBlock dataBlock = starFile.getDataBlock(string);
            System.out.println("DATA_" + dataBlock + " save frames:");
            System.out.println(dataBlock.getSaveFrames());
            System.out.println();
            System.out.println("DATA_" + dataBlock + " items:");
            System.out.println(dataBlock.getItemNames());
            System.out.println();
        }
    }
}

