/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.Model;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.WeakHashMap;
import molikin.AtomClassifier;
import molikin.AtomGraph;
import molikin.ResClassifier;
import molikin.Util;
import molikin.VirtualBackbone;

public class DataCache {
    static WeakHashMap dataEntries = new WeakHashMap();
    Model model;
    ResClassifier resC = null;
    Collection atomStates = null;
    AtomClassifier atomC = null;
    AtomGraph atomGraph = null;
    VirtualBackbone virtualBB = null;
    Collection modStates = null;

    protected DataCache(Model model) {
        this.model = model;
    }

    protected DataCache(Model model, Collection collection) {
        this.model = model;
        this.modStates = collection;
    }

    public static DataCache getDataFor(Model model, Collection collection) {
        DataCache dataCache = null;
        if (collection == null) {
            SoftReference softReference = (SoftReference)dataEntries.get(model);
            if (softReference != null) {
                dataCache = (DataCache)softReference.get();
            }
            if (dataCache == null) {
                dataCache = new DataCache(model);
                dataEntries.put(model, new SoftReference<DataCache>(dataCache));
            }
        } else {
            dataCache = new DataCache(model, collection);
        }
        return dataCache;
    }

    public static DataCache getDataFor(Model model) {
        return DataCache.getDataFor(model, null);
    }

    public ResClassifier getResClassifier() {
        if (this.resC == null) {
            this.resC = new ResClassifier(this.model.getResidues());
        }
        return this.resC;
    }

    public Collection getUniqueAtomStates() {
        if (this.atomStates == null) {
            this.atomStates = this.modStates == null ? Util.extractOrderedStatesByName(this.model) : Util.extractOrderedStatesByName(this.model, this.modStates);
        }
        return this.atomStates;
    }

    public AtomClassifier getAtomClassifier() {
        if (this.atomC == null) {
            this.atomC = new AtomClassifier(this.getUniqueAtomStates(), this.getResClassifier());
        }
        return this.atomC;
    }

    public AtomGraph getCovalentGraph() {
        if (this.atomGraph == null) {
            this.atomGraph = new AtomGraph(this.getUniqueAtomStates());
        }
        return this.atomGraph;
    }

    public VirtualBackbone getVirtualBackbone() {
        if (this.virtualBB == null) {
            this.virtualBB = new VirtualBackbone(this.model, this.model.getStates().values(), this.getResClassifier());
        }
        return this.virtualBB;
    }

    public String getModelId() {
        return this.model.toString();
    }
}

