/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import molikin.AtomIDer;

public class RotaramaIDer
implements AtomIDer {
    private static final String[] mcAtomNames = new String[]{" N  ", " H  ", " CA ", " C  ", " O  ", "_N__", "_H__", "_CA_", "_C__", "_O__"};
    static final DecimalFormat df2 = Strings.usDecimalFormat("0.00");
    static final DecimalFormat df3 = Strings.usDecimalFormat("0.0");
    HashMap<Residue, Double> rota;
    HashMap<Residue, Double> rama;

    public RotaramaIDer(Map map, Map map2) {
        this.rota = (HashMap)map;
        this.rama = (HashMap)map2;
    }

    public String identifyAtom(AtomState atomState) {
        Residue residue = atomState.getResidue();
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(atomState.getName());
        stringBuffer.append(atomState.getAltConf());
        stringBuffer.append(residue.getName());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getChain());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getSequenceNumber().trim());
        stringBuffer.append(residue.getInsertionCode());
        if (atomState.getTempFactor() > 0.0 || atomState.getOccupancy() < 1.0) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length() + 8);
            stringBuffer2.append(stringBuffer.toString().toLowerCase());
            if (atomState.getOccupancy() < 1.0) {
                stringBuffer2.append(" " + df2.format(atomState.getOccupancy()) + "B");
            } else {
                stringBuffer2.append(" B");
            }
            stringBuffer2.append(df2.format(atomState.getTempFactor()));
            return stringBuffer2.toString() + this.recallRotarama(atomState, residue);
        }
        return stringBuffer.toString().toLowerCase() + this.recallRotarama(atomState, residue);
    }

    private String recallRotarama(AtomState atomState, Residue residue) {
        Atom atom = atomState.getAtom();
        if (AminoAcid.isBackbone(atom)) {
            for (Residue residue2 : this.rama.keySet()) {
                if (!residue2.getCNIT().equals(residue.getCNIT())) continue;
                return " rama" + df3.format(100.0 * this.rama.get(residue)) + "%";
            }
        } else {
            for (Residue residue3 : this.rota.keySet()) {
                if (!residue3.getCNIT().equals(residue.getCNIT())) continue;
                return " rota" + df3.format(100.0 * this.rota.get(residue)) + "%";
            }
        }
        return "";
    }
}

