/*
 * Decompiled with CFR 0.152.
 */
package molikin.crayons;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Residue;
import driftwood.r3.Tuple3;
import java.util.HashMap;
import java.util.Map;
import molikin.AtomCrayon;
import molikin.BondCrayon;
import molikin.GuidePoint;
import molikin.RibbonCrayon;
import molikin.crayons.AbstractCrayon;

public class AltConfNetworkCrayon
extends AbstractCrayon
implements AtomCrayon,
BondCrayon,
RibbonCrayon {
    private final String[] DEFAULT_COLORS = new String[]{"red", "green", "blue", "peachtint", "purple", "yellow", "magenta", "lime", "peach", "cyan", "sky", "peach", "cyan", "orange", "greentint", "pink", "brown", "lilactint", "pintkint", "sea", "hotpink"};
    String[] colors;
    int colorIndex;
    HashMap<Residue, Integer> networks;

    public AltConfNetworkCrayon(Map map) {
        this.colors = this.DEFAULT_COLORS;
        this.networks = (HashMap)map;
    }

    public AltConfNetworkCrayon(String[] stringArray, Map map) {
        this.colors = (String[])stringArray.clone();
        this.networks = (HashMap)map;
    }

    public void forAtom(AtomState atomState) {
        this.setValue(atomState);
    }

    public void forBond(AtomState atomState, AtomState atomState2) {
        this.setValue(atomState);
    }

    public void forRibbon(Tuple3 tuple3, GuidePoint guidePoint, GuidePoint guidePoint2, int n, int n2) {
        this.setValue(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setValue(AtomState atomState) {
        int n = -1;
        if (this.networks == null) {
            throw new UnsupportedOperationException();
        }
        Atom atom = atomState.getAtom();
        if (atom == null) throw new UnsupportedOperationException();
        Residue residue = atom.getResidue();
        if (residue == null) throw new UnsupportedOperationException();
        if (this.networks.get(residue) != null) {
            n = this.networks.get(residue);
        }
        this.colorIndex = n % this.colors.length;
    }

    public String getColor() {
        return this.colorIndex < 0 ? null : this.colors[this.colorIndex];
    }

    public String getKinString() {
        return this.getColor();
    }
}

