/*
 * Decompiled with CFR 0.152.
 */
package molikin.gui;

import driftwood.data.UberSet;
import driftwood.gui.FatJList;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import molikin.gui.BallAndStickPane;
import molikin.gui.DrawingPane;
import molikin.gui.RibbonPane;
import molikin.gui.VanDerWaalsPane;

public class MainGuiPane
extends TablePane2
implements ListSelectionListener {
    public static final String[] BACKBONE_COLORS = new String[]{"white", "yellowtint", "peachtint", "greentint", "bluetint", "lilactint", "pinktint"};
    public JList drawingPaneList;
    CardLayout drawingCards;
    JPanel drawingPanel;
    CoordinateFile coordFile;
    String idCode;
    int paneNumber = 1;
    Collection paneListData;
    Icon greenPlus;
    Icon redMinus;

    public MainGuiPane(CoordinateFile coordinateFile) {
        this.coordFile = coordinateFile;
        this.paneListData = new ArrayList();
        this.idCode = this.coordFile.getIdCode() != null ? this.coordFile.getIdCode() : (this.coordFile.getFile() != null ? this.coordFile.getFile().getName() : "macromol");
        this.buildGUI();
        this.onNewBallAndStick(null);
    }

    private void buildGUI() {
        this.greenPlus = new ImageIcon(this.getClass().getResource("greenplus.png"));
        this.redMinus = new ImageIcon(this.getClass().getResource("redminus.png"));
        this.drawingPaneList = new FatJList(0, 10);
        this.drawingPaneList.setSelectionMode(0);
        this.drawingPaneList.setVisibleRowCount(8);
        this.drawingPaneList.addListSelectionListener(this);
        this.drawingCards = new CardLayout();
        this.drawingPanel = new JPanel(this.drawingCards);
        JButton jButton = new JButton(new ReflectiveAction("Ball & stick", this.greenPlus, this, "onNewBallAndStick"));
        jButton.setHorizontalAlignment(2);
        JButton jButton2 = new JButton(new ReflectiveAction("van der Waals", this.greenPlus, this, "onNewVanDerWaals"));
        jButton2.setHorizontalAlignment(2);
        JButton jButton3 = new JButton(new ReflectiveAction("Ribbons", this.greenPlus, this, "onNewRibbons"));
        jButton3.setHorizontalAlignment(2);
        JButton jButton4 = new JButton(new ReflectiveAction("Selected", this.redMinus, this, "onRemovePane"));
        jButton4.setHorizontalAlignment(2);
        JButton jButton5 = new JButton(new ReflectiveAction("All", this.redMinus, this, "onRemoveAll"));
        jButton5.setHorizontalAlignment(2);
        String string = "Doesn't work? Send the PDB/CIF file, the kinemage, and a description of your problem to vbc3@duke.edu";
        this.insets(10).memorize();
        this.addCell(new JLabel("<html><i>" + string + "</i></html>"), 3, 1).newRow();
        this.weights(0.0, 1.0).startSubtable();
        this.insets(10).hfill(true).weights(1.0, 0.0).memorize();
        this.addCell(jButton).newRow();
        this.addCell(jButton2).newRow();
        this.addCell(jButton3).newRow();
        this.addCell(jButton4).newRow();
        this.addCell(jButton5).newRow();
        this.weights(1.0, 1.0).addCell(MainGuiPane.strut(0, 0));
        this.endSubtable();
        this.weights(0.0, 1.0).vfill(true).addCell(new JScrollPane(this.drawingPaneList));
        this.hfill(true).vfill(true).addCell(this.drawingPanel);
        this.newRow();
        this.startSubtable(3, 1);
        this.insets(10).memorize();
    }

    void packParent() {
        Container container = this;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof Window)) continue;
            ((Window)container).pack();
            break;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        if (!this.drawingPaneList.getValueIsAdjusting() && (e = this.drawingPaneList.getSelectedValue()) != null) {
            this.drawingCards.show(this.drawingPanel, e.toString());
        }
    }

    void addDrawingPane(DrawingPane drawingPane) {
        this.drawingPanel.add((Component)((Object)drawingPane), drawingPane.toString());
        this.paneListData.add(drawingPane);
        this.drawingPaneList.setListData(this.paneListData.toArray());
        this.drawingPaneList.setSelectedValue(drawingPane, true);
        this.packParent();
    }

    void removeDrawingPane(DrawingPane drawingPane) {
        this.drawingPanel.remove((Component)((Object)drawingPane));
        this.paneListData.remove(drawingPane);
        Object e = this.drawingPaneList.getSelectedValue();
        this.drawingPaneList.setListData(this.paneListData.toArray());
        this.drawingPaneList.setSelectedValue(e, true);
    }

    public void onRemovePane(ActionEvent actionEvent) {
        this.removeDrawingPane((DrawingPane)this.drawingPaneList.getSelectedValue());
    }

    public void onRemoveAll(ActionEvent actionEvent) {
        ArrayList arrayList = new ArrayList(this.paneListData);
        for (DrawingPane drawingPane : arrayList) {
            this.removeDrawingPane(drawingPane);
        }
    }

    public void onNewBallAndStick(ActionEvent actionEvent) {
        this.addDrawingPane(new BallAndStickPane(this.coordFile, this.paneNumber++ + " - Ball & stick"));
    }

    public void onNewVanDerWaals(ActionEvent actionEvent) {
        this.addDrawingPane(new VanDerWaalsPane(this.coordFile, this.paneNumber++ + " - van der Waals"));
    }

    public void onNewRibbons(ActionEvent actionEvent) {
        this.addDrawingPane(new RibbonPane(this.coordFile, this.paneNumber++ + " - Ribbons"));
    }

    public void printKinemage(PrintWriter printWriter) {
        Collection collection = this.getSelectedModels();
        boolean bl = collection.size() > 1;
        Collection collection2 = this.getSelectedChains();
        int n = 0;
        for (Model model : collection) {
            if (bl) {
                printWriter.println("@group {" + this.idCode + " " + model + "} dominant animate master= {all models}");
            }
            int n2 = 0;
            for (String string : collection2) {
                if (model.getChain(string) != null) {
                    if (bl) {
                        printWriter.println("@subgroup {chain" + string + "} dominant master= {chain" + string + "}");
                    } else {
                        printWriter.println("@group {" + this.idCode + " " + string + "} dominant");
                    }
                    for (DrawingPane drawingPane : this.paneListData) {
                        String string2 = BACKBONE_COLORS[(bl ? n : n2) % BACKBONE_COLORS.length];
                        drawingPane.printKinemage(printWriter, model, string, this.idCode, string2);
                    }
                }
                ++n2;
            }
            ++n;
        }
        printWriter.flush();
    }

    public Collection getSelectedModels() {
        HashSet hashSet = new HashSet();
        for (DrawingPane drawingPane : this.paneListData) {
            hashSet.addAll(drawingPane.getSelectedModels());
        }
        ArrayList arrayList = new ArrayList(this.coordFile.getModels());
        arrayList.retainAll(hashSet);
        return arrayList;
    }

    public Collection getSelectedChains() {
        HashSet hashSet = new HashSet();
        for (Object object : this.paneListData) {
            hashSet.addAll(object.getSelectedChains());
        }
        UberSet uberSet = new UberSet();
        for (Model model : this.coordFile.getModels()) {
            uberSet.addAll(model.getChainIDs());
        }
        uberSet.retainAll(hashSet);
        return uberSet;
    }
}

