/*
 * Decompiled with CFR 0.152.
 */
package molikin.kingplugin;

import driftwood.gui.ReflectiveAction;
import driftwood.moldb2.CoordinateFile;
import driftwood.util.StreamTank;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import king.KinCanvas;
import king.KingMain;
import king.ToolBox;
import king.ToolServices;
import king.core.Kinemage;
import molikin.gui.MainGuiPane;

public class MolikinWindow {
    ToolBox parent;
    KingMain kMain;
    KinCanvas kCanvas;
    ToolServices services;
    CoordinateFile coordFile;
    JFrame frame;
    MainGuiPane guiPane;
    int kinNumber = 1;

    public MolikinWindow(ToolBox toolBox, CoordinateFile coordinateFile) {
        this.parent = toolBox;
        this.kMain = toolBox.kMain;
        this.kCanvas = toolBox.kCanvas;
        this.services = toolBox.services;
        this.coordFile = coordinateFile;
        this.buildGUI();
    }

    void buildGUI() {
        Serializable serializable;
        Serializable serializable2;
        this.guiPane = new MainGuiPane(this.coordFile);
        this.guiPane.weights(1.0, 0.0).addCell(new JButton(new ReflectiveAction("Done", null, this, "onDone")));
        this.guiPane.weights(0.0, 0.0).addCell(new JButton(new ReflectiveAction("As new kinemage", null, this, "onCreateKinemage")));
        this.guiPane.weights(0.0, 0.0).addCell(new JButton(new ReflectiveAction("Append to current", null, this, "onAppendKinemage")));
        String string = "Molikin";
        if (this.coordFile.getFile() != null) {
            string = this.coordFile.getFile().getName() + " - " + string;
        } else if (this.coordFile.getIdCode() != null) {
            string = this.coordFile.getIdCode() + " - " + string;
        }
        this.frame = new JFrame(string);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setContentPane(this.guiPane);
        this.frame.pack();
        Container container = this.kMain.getContentContainer();
        if (container != null) {
            serializable2 = container.getLocation();
            serializable = this.frame.getSize();
            Dimension dimension = container.getSize();
            ((Point)serializable2).x += dimension.width - ((Dimension)serializable).width + 64;
            ((Point)serializable2).y += (dimension.height - ((Dimension)serializable).height) / 2;
            this.frame.setLocation((Point)serializable2);
        }
        serializable2 = this.frame.getRootPane().getInputMap(2);
        ((InputMap)serializable2).put(KeyStroke.getKeyStroke(27, 0), "done");
        serializable = this.frame.getRootPane().getActionMap();
        ((ActionMap)serializable).put("done", new ReflectiveAction(null, null, this, "onDone"));
        this.frame.setVisible(true);
    }

    public void onCreateKinemage(ActionEvent actionEvent) {
        this.buildKinemage(null);
    }

    public void onAppendKinemage(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        this.buildKinemage(kinemage);
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }

    public void onDone(ActionEvent actionEvent) {
        this.frame.dispose();
    }

    void buildKinemage(Kinemage kinemage) {
        StreamTank streamTank = new StreamTank();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(streamTank));
        printWriter.println("@kinemage " + this.kinNumber++);
        printWriter.println("@onewidth");
        this.guiPane.printKinemage(printWriter);
        printWriter.flush();
        streamTank.close();
        this.kMain.getKinIO().loadStream((InputStream)streamTank.getInputStream(), streamTank.size(), kinemage);
    }
}

