/*
 * Decompiled with CFR 0.152.
 */
package molikin.logic;

import driftwood.data.CheapSet;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import molikin.AtomClassifier;
import molikin.BallPrinter;
import molikin.DataCache;
import molikin.ResClassifier;
import molikin.RotaramaIDer;
import molikin.StickPrinter;
import molikin.Util;
import molikin.VirtualBackbone;
import molikin.crayons.AltConfCrayon;
import molikin.crayons.AltConfNetworkCrayon;
import molikin.crayons.BfactorCrayon;
import molikin.crayons.CompositeCrayon;
import molikin.crayons.DisulfideCrayon;
import molikin.crayons.HalfBondElementCrayon;
import molikin.crayons.OccupancyCrayon;
import molikin.crayons.ResTypeCrayon;
import molikin.crayons.RotaramaCrayon;
import molikin.logic.Logic;

public class BallAndStickLogic
implements Logic {
    public static final Object COLOR_BY_MC_SC = "mainchain / sidechain";
    public static final Object COLOR_BY_RES_TYPE = "residue type";
    public static final Object COLOR_BY_ELEMENT = "element";
    public static final Object COLOR_BY_B_FACTOR = "B factor";
    public static final Object COLOR_BY_OCCUPANCY = "occupancy";
    public static final Object COLOR_BY_ROTARAMA = "rota/rama score";
    public static final Object COLOR_BY_ALT_NETWORK = "alt conf network";
    static final DecimalFormat df = new DecimalFormat("00");
    PrintWriter out = null;
    StickPrinter sp = null;
    BallPrinter bp = null;
    public boolean doProtein;
    public boolean doNucleic;
    public boolean doHets;
    public boolean doMetals;
    public boolean doWater;
    public boolean doVirtualBB;
    public boolean doMainchain;
    public boolean doSidechains;
    public boolean doHydrogens;
    public boolean doDisulfides;
    public boolean doBallsOnCarbon;
    public boolean doBallsOnAtoms;
    public boolean doLigate;
    public Object colorBy = COLOR_BY_MC_SC;
    public int width = -1;
    public String scColor = "cyan";
    public Map rota = null;
    public Map rama = null;
    public Map altConfNetworks = null;

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string) {
        this.printKinemage(printWriter, model, set, "", string);
    }

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string, String string2) {
        this.printKinemage(printWriter, model, null, set, string, string2);
    }

    public void printKinemage(PrintWriter printWriter, Model model, Collection collection, Set set, String string, String string2) {
        this.out = printWriter;
        this.sp = new StickPrinter(printWriter);
        this.bp = new BallPrinter(printWriter);
        if (this.colorBy == COLOR_BY_MC_SC) {
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new DisulfideCrayon()));
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_RES_TYPE) {
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new ResTypeCrayon()));
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_ELEMENT) {
            this.sp.setHalfBonds(true);
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new HalfBondElementCrayon()));
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_B_FACTOR) {
            this.sp.setHalfBonds(true);
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new BfactorCrayon()));
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new BfactorCrayon()));
        } else if (this.colorBy == COLOR_BY_OCCUPANCY) {
            this.sp.setHalfBonds(true);
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new OccupancyCrayon()));
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new OccupancyCrayon()));
        } else if (this.colorBy == COLOR_BY_ROTARAMA && this.rota != null && this.rama != null) {
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new RotaramaCrayon(this.rota, this.rama)));
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new RotaramaCrayon(this.rota, this.rama)));
            this.sp.setAtomIDer(new RotaramaIDer(this.rota, this.rama));
        } else if (this.colorBy == COLOR_BY_ALT_NETWORK && this.altConfNetworks != null) {
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfNetworkCrayon(this.altConfNetworks)).add(new AltConfCrayon()).add(new DisulfideCrayon()));
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfNetworkCrayon(this.altConfNetworks)).add(new AltConfCrayon()));
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.doProtein) {
            this.printProtein(model, collection, set, string, string2);
        }
        if (this.doNucleic) {
            this.printNucAcid(model, collection, set, string, string2);
        }
        if (this.doHets) {
            this.printHets(model, collection, set, string);
        }
        if (this.doMetals) {
            this.printMetals(model, collection, set, string);
        }
        if (this.doWater) {
            this.printWaters(model, collection, set, string);
        }
        this.out.flush();
        this.out = null;
        this.sp = null;
        this.bp = null;
    }

    void printProtein(Model model, Collection collection, Set set, String string, String string2) {
        Object object;
        DataCache dataCache = DataCache.getDataFor(model, collection);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.proteinRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection2 = dataCache.getCovalentGraph().getBonds();
        String string3 = this.width != -1 ? " width= " + this.width : "";
        String string4 = "";
        if (string != null && !string.trim().equals("")) {
            string4 = Util.isNumeric(dataCache.getModelId()) ? " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase() : " m" + dataCache.getModelId() + "_" + string.toLowerCase();
        }
        if (this.doVirtualBB || atomClassifier.mcNotCa == 0) {
            object = this.doMainchain && atomClassifier.mcNotCa != 0 ? " off" : "";
            this.out.println("@vectorlist {protein ca} color= " + string2 + " master= {protein} master= {Calphas}" + (String)object + string3);
            VirtualBackbone virtualBackbone = dataCache.getVirtualBackbone();
            this.sp.printSticks(virtualBackbone.getProteinBonds(), null, null, cheapSet, cheapSet, string4, this.doLigate);
        }
        if (this.doMainchain && atomClassifier.mcHeavy.size() > 0) {
            this.out.println("@vectorlist {protein mc} color= " + string2 + " master= {protein} master= {mainchain}" + string3);
            this.sp.printSticks(collection2, atomClassifier.mcHeavy, atomClassifier.mcHeavy, cheapSet, cheapSet, string4);
            if (this.doHydrogens && atomClassifier.mcHydro.size() > 0) {
                this.out.println("@vectorlist {protein mcH} color= gray master= {protein} master= {mainchain} master= {H}" + string3);
                this.sp.printSticks(collection2, atomClassifier.mcHydro, atomClassifier.mcHeavy, cheapSet, cheapSet, string4);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.mcHeavy, cheapSet, this.doBallsOnCarbon ? string2 : null, "master= {protein} master= {mainchain}");
            }
        }
        if (this.doSidechains && atomClassifier.scHeavy.size() > 0) {
            this.out.println("@vectorlist {protein sc} color= " + this.scColor + " master= {protein} master= {sidechains}" + string3);
            this.sp.printSticks(collection2, atomClassifier.scHeavy, atomClassifier.bioHeavy, cheapSet, resClassifier.proteinRes, string4);
            if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                this.out.println("@vectorlist {protein scH} color= gray master= {protein} master= {sidechains} master= {H}" + string3);
                this.sp.printSticks(collection2, atomClassifier.scHydro, atomClassifier.bioHeavy, cheapSet, cheapSet, string4);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.scHeavy, cheapSet, this.doBallsOnCarbon ? this.scColor : null, "master= {protein} master= {sidechains}");
            }
        }
        if (this.doDisulfides) {
            object = Util.selectDisulfideResidues(collection2);
            object.retainAll(cheapSet);
            if (atomClassifier.scHeavy.size() > 0 && object.size() > 0) {
                this.out.println("@vectorlist {protein ss} color= yellow master= {protein} master= {-SS-}" + string3);
                this.sp.printSticks(collection2, atomClassifier.scHeavy, atomClassifier.bioHeavy, (Set)object, null, string4);
                if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                    this.out.println("@vectorlist {protein ssH} color= gray master= {protein} master= {-SS-} master= {H}" + string3);
                    this.sp.printSticks(collection2, atomClassifier.scHydro, atomClassifier.bioHeavy, (Set)object, (Set)object, string4);
                }
                if (this.doBallsOnAtoms) {
                    this.printAtomBalls(atomClassifier.scHeavy, (Set)object, this.doBallsOnCarbon ? this.scColor : null, "master= {protein} master= {-SS-}");
                }
            }
        }
    }

    void printNucAcid(Model model, Collection collection, Set set, String string, String string2) {
        DataCache dataCache = DataCache.getDataFor(model, collection);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.nucAcidRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection2 = dataCache.getCovalentGraph().getBonds();
        String string3 = this.width != -1 ? " width= " + this.width : "";
        String string4 = "";
        if (string != null && !string.trim().equals("")) {
            string4 = Util.isNumeric(dataCache.getModelId()) ? " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase() : " m" + dataCache.getModelId() + "_" + string.toLowerCase();
        }
        if (this.doVirtualBB) {
            String string5 = this.doMainchain ? " off" : "";
            this.out.println("@vectorlist {nuc. acid virtual bb} color= " + string2 + " master= {nucleic acid} master= {virtual bb}" + string5 + string3);
            VirtualBackbone virtualBackbone = dataCache.getVirtualBackbone();
            this.sp.printSticks(virtualBackbone.getNucAcidBonds(), null, null, cheapSet, cheapSet, string4);
        }
        if (this.doMainchain && atomClassifier.mcHeavy.size() > 0) {
            this.out.println("@vectorlist {nuc. acid mc} color= " + string2 + " master= {nucleic acid} master= {mainchain}" + string3);
            this.sp.printSticks(collection2, atomClassifier.mcHeavy, atomClassifier.mcHeavy, cheapSet, cheapSet, string4);
            if (this.doHydrogens && atomClassifier.mcHydro.size() > 0) {
                this.out.println("@vectorlist {nuc. acid mcH} color= gray master= {nucleic acid} master= {mainchain} master= {H}" + string3);
                this.sp.printSticks(collection2, atomClassifier.mcHydro, atomClassifier.mcHeavy, cheapSet, cheapSet, string4);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.mcHeavy, cheapSet, this.doBallsOnCarbon ? string2 : null, "master= {nucleic acid} master= {mainchain}");
            }
        }
        if (this.doSidechains && atomClassifier.scHeavy.size() > 0) {
            this.out.println("@vectorlist {nuc. acid sc} color= " + this.scColor + " master= {nucleic acid} master= {sidechains}" + string3);
            this.sp.printSticks(collection2, atomClassifier.scHeavy, atomClassifier.bioHeavy, cheapSet, cheapSet, string4);
            if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                this.out.println("@vectorlist {nuc. acid scH} color= gray master= {nucleic acid} master= {sidechains} master= {H}" + string3);
                this.sp.printSticks(collection2, atomClassifier.scHydro, atomClassifier.scHeavy, cheapSet, cheapSet, string4);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.scHeavy, cheapSet, this.doBallsOnCarbon ? this.scColor : null, "master= {nucleic acid} master= {sidechains}");
            }
        }
    }

    void printHets(Model model, Set set, String string) {
        this.printHets(model, null, set, string);
    }

    void printHets(Model model, Collection collection, Set set, String string) {
        CheapSet cheapSet;
        DataCache dataCache = DataCache.getDataFor(model, collection);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet2 = new CheapSet(resClassifier.ohetRes);
        cheapSet2.addAll(resClassifier.unknownRes);
        cheapSet2.retainAll(set);
        if (cheapSet2.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection2 = dataCache.getCovalentGraph().getBonds();
        String string2 = this.width != -1 ? " width= " + this.width : "";
        String string3 = Util.isNumeric(dataCache.getModelId()) ? " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase() : " m" + dataCache.getModelId() + "_" + string.toLowerCase();
        if (atomClassifier.hetHeavy.size() == 0) {
            return;
        }
        this.out.println("@vectorlist {het} color= pink master= {hets}");
        this.sp.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.hetHeavy, cheapSet2, cheapSet2, string3);
        if (this.doBallsOnAtoms) {
            this.printAtomBalls(atomClassifier.hetHeavy, cheapSet2, this.doBallsOnCarbon ? "pink" : null, "master= {hets}");
        }
        if (this.doHydrogens && atomClassifier.hetHydro.size() > 0) {
            this.out.println("@vectorlist {hetH} color= gray master= {hets} master= {H}" + string2);
            this.sp.printSticks(collection2, atomClassifier.hetHydro, atomClassifier.hetHeavy, cheapSet2, cheapSet2, string3);
        }
        if (this.doProtein) {
            cheapSet = new CheapSet(set);
            cheapSet.retainAll(resClassifier.proteinRes);
            if (cheapSet.size() > 0 && this.doMainchain && atomClassifier.mcHeavy.size() > 0) {
                this.out.println("@vectorlist {het - protein mc} color= pinktint master= {hets} master= {protein} master= {mainchain}" + string2);
                this.sp.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.mcHeavy, cheapSet2, cheapSet, string3);
            }
            if (cheapSet.size() > 0 && this.doSidechains && atomClassifier.scHeavy.size() > 0) {
                this.out.println("@vectorlist {het - protein sc} color= pinktint master= {hets} master= {protein} master= {sidechains}" + string2);
                this.sp.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.scHeavy, cheapSet2, cheapSet, string3);
            }
        }
        if (this.doNucleic) {
            cheapSet = new CheapSet(set);
            cheapSet.retainAll(resClassifier.nucAcidRes);
            if (cheapSet.size() > 0 && this.doMainchain && atomClassifier.mcHeavy.size() > 0) {
                this.out.println("@vectorlist {het - nuc. acid mc} color= pinktint master= {hets} master= {nucleic acid} master= {mainchain}" + string2);
                this.sp.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.mcHeavy, cheapSet2, cheapSet, string3);
            }
            if (cheapSet.size() > 0 && this.doSidechains && atomClassifier.scHeavy.size() > 0) {
                this.out.println("@vectorlist {het - nuc. acid sc} color= pinktint master= {hets} master= {nucleic acid} master= {sidechains}" + string2);
                this.sp.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.scHeavy, cheapSet2, cheapSet, string3);
            }
        }
    }

    void printMetals(Model model, Set set, String string) {
        this.printMetals(model, null, set, string);
    }

    void printMetals(Model model, Collection collection, Set set, String string) {
        DataCache dataCache = DataCache.getDataFor(model, collection);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.metalRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        if (atomClassifier.metal.size() == 0) {
            return;
        }
        String string2 = Util.isNumeric(dataCache.getModelId()) ? " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase() : " m" + dataCache.getModelId() + "_" + string.toLowerCase();
        this.out.println("@spherelist {metals} color= gray radius= 0.5 master= {metals}");
        this.bp.printBalls(atomClassifier.metal, cheapSet, string2);
    }

    void printWaters(Model model, Set set, String string) {
        this.printWaters(model, null, set, string);
    }

    void printWaters(Model model, Collection collection, Set set, String string) {
        DataCache dataCache = DataCache.getDataFor(model, collection);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.waterRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        if (atomClassifier.watHeavy.size() == 0) {
            return;
        }
        String string2 = this.width != -1 ? " width= " + this.width : "";
        String string3 = Util.isNumeric(dataCache.getModelId()) ? " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase() : " m" + dataCache.getModelId() + "_" + string.toLowerCase();
        this.out.println("@balllist {waters} color= peachtint radius= 0.15 master= {waters}");
        this.bp.printBalls(atomClassifier.watHeavy, cheapSet, string3);
        if (this.doHydrogens && atomClassifier.watHydro.size() > 0) {
            Collection collection2 = dataCache.getCovalentGraph().getBonds();
            this.out.println("@vectorlist {waterH} color= gray master= {waters} master= {H}" + string2);
            this.sp.printSticks(collection2, atomClassifier.watHydro, atomClassifier.watHeavy, cheapSet, cheapSet, string3);
        }
    }

    void printAtomBalls(Collection collection, Set set, String string, String string2) {
        Collection<Object> collection2;
        Object object;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        for (Object object2 : collection) {
            object = ((AtomState)object2).getElement();
            if (((String)object).equals("H") || ((String)object).equals("Q") || string == null && ((String)object).equals("C") || !set.contains(((AtomState)object2).getResidue())) continue;
            collection2 = (Collection)hashMap.get(object);
            if (collection2 == null) {
                collection2 = new ArrayList<Object>();
                hashMap.put(object, (ArrayList<Object>)collection2);
            }
            collection2.add(object2);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (Collection)hashMap.get(object2);
            collection2 = Util.getElementColor((String)object2);
            this.out.println("@balllist {" + (String)object2 + " balls} color= " + (String)((Object)collection2) + " radius= 0.2 master= {" + (String)object2 + "} " + string2);
            this.bp.printBalls((Collection)object);
        }
    }
}

