/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.VertexEvaluator;
import driftwood.isosurface.VertexLocator;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import java.io.IOException;
import java.text.DecimalFormat;

public abstract class CrystalVertexSource
implements VertexLocator,
VertexEvaluator {
    public int aSteps;
    public int aMin;
    public int aMax;
    public int aCount;
    public int bSteps;
    public int bMin;
    public int bMax;
    public int bCount;
    public int cSteps;
    public int cMin;
    public int cMax;
    public int cCount;
    public double aLength;
    public double bLength;
    public double cLength;
    public double alpha;
    public double beta;
    public double gamma;
    public double mean = 0.0;
    public double sigma = 1.0;
    double tax;
    double tbx;
    double tby;
    double tcx;
    double tcy;
    double tcz;

    void init(boolean bl) throws IOException {
        this.readHeader();
        if (bl) {
            this.readData();
        }
        this.initTransformMatrix();
    }

    abstract void readHeader() throws IOException;

    abstract void readData() throws IOException;

    public abstract boolean hasData();

    void initTransformMatrix() {
        double d = Math.cos(Math.toRadians(this.alpha));
        double d2 = Math.cos(Math.toRadians(this.beta));
        double d3 = Math.cos(Math.toRadians(this.gamma));
        double d4 = Math.sin(Math.toRadians(this.gamma));
        this.tax = this.aLength;
        this.tbx = this.bLength * d3;
        this.tby = this.bLength * d4;
        this.tcx = this.cLength * d2;
        this.tcy = this.cLength * (d - d2 * d3) / d4;
        this.tcz = Math.sqrt(this.cLength * this.cLength - this.tcx * this.tcx - this.tcy * this.tcy);
        if (Math.abs(this.tbx) < 1.0E-12) {
            this.tbx = 0.0;
        }
        if (Math.abs(this.tcx) < 1.0E-12) {
            this.tcx = 0.0;
        }
        if (Math.abs(this.tcy) < 1.0E-12) {
            this.tcy = 0.0;
        }
    }

    public double evaluateVertex(int n, int n2, int n3) {
        n -= this.aMin;
        n2 -= this.bMin;
        n3 -= this.cMin;
        if ((n %= this.aSteps) < 0) {
            n += this.aSteps;
        }
        if ((n2 %= this.bSteps) < 0) {
            n2 += this.bSteps;
        }
        if ((n3 %= this.cSteps) < 0) {
            n3 += this.cSteps;
        }
        try {
            if (n >= this.aCount || n2 >= this.bCount || n3 >= this.cCount) {
                return Double.NaN;
            }
            return this.getValue(n, n2, n3);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SoftLog.err.println(arrayIndexOutOfBoundsException.getMessage());
            SoftLog.err.println("    (i,j,k)=" + n + " " + n2 + " " + n3 + "; count=" + this.aCount + " " + this.bCount + " " + this.cCount + "; steps=" + this.aSteps + " " + this.bSteps + " " + this.cSteps);
            return Double.NaN;
        }
    }

    public abstract double getValue(int var1, int var2, int var3);

    public double evaluateAtPoint(double d, double d2, double d3) {
        double[] dArray = new double[3];
        this.findVertexForPoint(d, d2, d3, dArray);
        int n = (int)Math.floor(dArray[0]);
        int n2 = (int)Math.floor(dArray[1]);
        int n3 = (int)Math.floor(dArray[2]);
        double d4 = dArray[0] - (double)n;
        double d5 = dArray[1] - (double)n2;
        double d6 = dArray[2] - (double)n3;
        return (1.0 - d4) * (1.0 - d5) * (1.0 - d6) * this.evaluateVertex(n, n2, n3) + (1.0 - d4) * (1.0 - d5) * d6 * this.evaluateVertex(n, n2, n3 + 1) + (1.0 - d4) * d5 * (1.0 - d6) * this.evaluateVertex(n, n2 + 1, n3) + (1.0 - d4) * d5 * d6 * this.evaluateVertex(n, n2 + 1, n3 + 1) + d4 * (1.0 - d5) * (1.0 - d6) * this.evaluateVertex(n + 1, n2, n3) + d4 * (1.0 - d5) * d6 * this.evaluateVertex(n + 1, n2, n3 + 1) + d4 * d5 * (1.0 - d6) * this.evaluateVertex(n + 1, n2 + 1, n3) + d4 * d5 * d6 * this.evaluateVertex(n + 1, n2 + 1, n3 + 1);
    }

    public void locateVertex(int n, int n2, int n3, double[] dArray) {
        double d = (double)n / (double)this.aSteps;
        double d2 = (double)n2 / (double)this.bSteps;
        double d3 = (double)n3 / (double)this.cSteps;
        dArray[0] = this.tax * d + this.tbx * d2 + this.tcx * d3;
        dArray[1] = this.tby * d2 + this.tcy * d3;
        dArray[2] = this.tcz * d3;
    }

    public void findVertexForPoint(double d, double d2, double d3, int[] nArray) {
        double d4 = d3 / this.tcz;
        double d5 = (d2 - this.tcy * d4) / this.tby;
        double d6 = (d - this.tcx * d4 - this.tbx * d5) / this.tax;
        nArray[0] = (int)Math.round(d6 * (double)this.aSteps);
        nArray[1] = (int)Math.round(d5 * (double)this.bSteps);
        nArray[2] = (int)Math.round(d4 * (double)this.cSteps);
    }

    public void findVertexForPoint(double d, double d2, double d3, double[] dArray) {
        double d4 = d3 / this.tcz;
        double d5 = (d2 - this.tcy * d4) / this.tby;
        double d6 = (d - this.tcx * d4 - this.tbx * d5) / this.tax;
        dArray[0] = d6 * (double)this.aSteps;
        dArray[1] = d5 * (double)this.bSteps;
        dArray[2] = d4 * (double)this.cSteps;
    }

    public boolean isComplete() {
        return this.aCount >= this.aSteps && this.bCount >= this.bSteps && this.cCount >= this.cSteps;
    }

    public boolean isOrthogonal() {
        return this.alpha == 90.0 && this.beta == 90.0 && this.gamma == 90.0;
    }

    public String kinUnitCell() {
        DecimalFormat decimalFormat = Strings.usDecimalFormat("0.###");
        return "@vectorlist {unit cell axes} color= gray\n{a}P 0 0 0 {a} " + decimalFormat.format(this.tax) + " 0 0\n" + "{b}P 0 0 0 {b} " + decimalFormat.format(this.tbx) + " " + decimalFormat.format(this.tby) + " 0\n" + "{c}P 0 0 0 {c} " + decimalFormat.format(this.tcx) + " " + decimalFormat.format(this.tcy) + " " + decimalFormat.format(this.tcz);
    }

    public String toString() {
        return "A: " + this.aMin + " -> " + this.aMax + " (" + this.aCount + " samples); " + this.aLength + " A in " + this.aSteps + " samples\n" + "B: " + this.bMin + " -> " + this.bMax + " (" + this.bCount + " samples); " + this.bLength + " A in " + this.bSteps + " samples\n" + "C: " + this.cMin + " -> " + this.cMax + " (" + this.cCount + " samples); " + this.cLength + " A in " + this.cSteps + " samples\n" + "Is complete? " + this.isComplete() + "; Is orthogonal? " + this.isOrthogonal() + "\n" + "alpha = " + this.alpha + "; beta = " + this.beta + "; gamma = " + this.gamma + "\n" + "|a| = |<" + this.tax + ", 0, 0>| = " + Math.sqrt(this.tax * this.tax) + "\n" + "|b| = |<" + this.tbx + ", " + this.tby + ", 0>| = " + Math.sqrt(this.tbx * this.tbx + this.tby * this.tby) + "\n" + "|c| = |<" + this.tcx + ", " + this.tcy + ", " + this.tcz + ">| = " + Math.sqrt(this.tcx * this.tcx + this.tcy * this.tcy + this.tcz * this.tcz) + "\n" + "mean = " + this.mean + "; sigma = " + this.sigma;
    }
}

