/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.r3.Triple;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AminoAcid {
    static final String AA_NAMES = "GLY,ALA,VAL,LEU,ILE,PRO,PHE,TYR,TRP,SER,THR,CYS,MET,MSE,LYS,HIS,ARG,ASP,ASN,GLN,GLU";
    static final Set BACKBONE_ATOM_NAMES = new HashSet();
    private static final Map threeToOneLetter;
    private static final Map oneToThreeLetter;

    private AminoAcid() {
    }

    public static String translate(String string) {
        String string2 = "";
        string2 = string.length() >= 3 ? (threeToOneLetter.containsKey(string) ? (String)threeToOneLetter.get(string) : "X") : (oneToThreeLetter.containsKey(string) ? (String)oneToThreeLetter.get(string) : "unk");
        return string2;
    }

    public static double getTau(Residue residue, ModelState modelState) throws AtomException {
        AtomState atomState = modelState.get(residue.getAtom(" N  "));
        AtomState atomState2 = modelState.get(residue.getAtom(" CA "));
        AtomState atomState3 = modelState.get(residue.getAtom(" C  "));
        return Triple.angle(atomState, atomState2, atomState3);
    }

    public static double getTauDeviation(Residue residue, ModelState modelState) throws AtomException {
        double d = AminoAcid.getTau(residue, modelState);
        double d2 = residue.getName().equals("GLY") ? d - 112.5 : (residue.getName().equals("PRO") ? d - 111.8 : d - 111.2);
        return d2;
    }

    public static double getPhi(Model model, Residue residue, ModelState modelState) throws ResidueException, AtomException {
        Residue residue2 = residue.getPrev(model);
        if (residue2 == null) {
            throw new ResidueException("Can't calculate PHI without a preceding residue");
        }
        AtomState atomState = modelState.get(residue2.getAtom(" C  "));
        AtomState atomState2 = modelState.get(residue.getAtom(" N  "));
        AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
        AtomState atomState4 = modelState.get(residue.getAtom(" C  "));
        if (atomState.sqDistance(atomState2) > 4.0) {
            throw new ResidueException("Preceding residue is too far away to be covalently bonded");
        }
        return Triple.dihedral(atomState, atomState2, atomState3, atomState4);
    }

    public static double getPsi(Model model, Residue residue, ModelState modelState) throws ResidueException, AtomException {
        AtomState atomState;
        Residue residue2 = residue.getNext(model);
        if (residue2 == null) {
            throw new ResidueException("Can't calculate PSI without a following residue");
        }
        AtomState atomState2 = modelState.get(residue.getAtom(" N  "));
        AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
        AtomState atomState4 = modelState.get(residue.getAtom(" C  "));
        if (atomState4.sqDistance(atomState = modelState.get(residue2.getAtom(" N  "))) > 4.0) {
            throw new ResidueException("Following residue is too far away to be covalently bonded");
        }
        return Triple.dihedral(atomState2, atomState3, atomState4, atomState);
    }

    public static boolean isPrepro(Model model, Residue residue, ModelState modelState) {
        Residue residue2 = residue.getNext(model);
        if (residue2 == null) {
            return false;
        }
        if (residue2.getName().equals("PRO")) {
            try {
                AtomState atomState = modelState.get(residue2.getAtom(" N  "));
                AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                return atomState2.sqDistance(atomState) < 4.0;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isCisPeptide(Model model, Residue residue, ModelState modelState) {
        Residue residue2 = residue.getPrev(model);
        if (residue2 == null) {
            return false;
        }
        try {
            AtomState atomState = modelState.get(residue2.getAtom(" CA "));
            AtomState atomState2 = modelState.get(residue2.getAtom(" C  "));
            AtomState atomState3 = modelState.get(residue.getAtom(" N  "));
            AtomState atomState4 = modelState.get(residue.getAtom(" CA "));
            double d = Triple.dihedral(atomState, atomState2, atomState3, atomState4);
            return d > -30.0 && d < 30.0;
        }
        catch (AtomException atomException) {
            return false;
        }
    }

    public static boolean isBackbone(Atom atom) {
        return BACKBONE_ATOM_NAMES.contains(atom.getName());
    }

    public static boolean isAminoAcid(Residue residue) {
        return AA_NAMES.indexOf(residue.getName()) != -1;
    }

    public static boolean isAminoAcid(String string) {
        return AA_NAMES.indexOf(string = string.toUpperCase()) != -1;
    }

    public static boolean isExtendedAminoAcid(String string) {
        boolean bl = false;
        string = string.toUpperCase();
        String[] stringArray = AA_NAMES.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string.indexOf(string2) == -1) continue;
            bl = true;
        }
        return bl;
    }

    public static String getAAName(String string) {
        string = string.toUpperCase();
        String[] stringArray = AA_NAMES.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string.indexOf(string2);
            if (n == -1) continue;
            return string.substring(n - 1, n + 3);
        }
        return "UNK";
    }

    static {
        BACKBONE_ATOM_NAMES.add(" N  ");
        BACKBONE_ATOM_NAMES.add(" H  ");
        BACKBONE_ATOM_NAMES.add("1H  ");
        BACKBONE_ATOM_NAMES.add("2H  ");
        BACKBONE_ATOM_NAMES.add("3H  ");
        BACKBONE_ATOM_NAMES.add(" CA ");
        BACKBONE_ATOM_NAMES.add(" HA ");
        BACKBONE_ATOM_NAMES.add("1HA ");
        BACKBONE_ATOM_NAMES.add("2HA ");
        BACKBONE_ATOM_NAMES.add(" C  ");
        BACKBONE_ATOM_NAMES.add(" O  ");
        BACKBONE_ATOM_NAMES.add(" OXT");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("gly", "G");
        hashMap.put("ala", "A");
        hashMap.put("val", "V");
        hashMap.put("leu", "L");
        hashMap.put("ile", "I");
        hashMap.put("met", "M");
        hashMap.put("pro", "P");
        hashMap.put("phe", "F");
        hashMap.put("trp", "W");
        hashMap.put("ser", "S");
        hashMap.put("thr", "T");
        hashMap.put("asn", "N");
        hashMap.put("gln", "Q");
        hashMap.put("tyr", "Y");
        hashMap.put("cys", "C");
        hashMap.put("lys", "K");
        hashMap.put("arg", "R");
        hashMap.put("his", "H");
        hashMap.put("asp", "D");
        hashMap.put("glu", "E");
        hashMap.put("GLY", "G");
        hashMap.put("ALA", "A");
        hashMap.put("VAL", "V");
        hashMap.put("LEU", "L");
        hashMap.put("ILE", "I");
        hashMap.put("MET", "M");
        hashMap.put("PRO", "P");
        hashMap.put("PHE", "F");
        hashMap.put("TRP", "W");
        hashMap.put("SER", "S");
        hashMap.put("THR", "T");
        hashMap.put("ASN", "N");
        hashMap.put("GLN", "Q");
        hashMap.put("TYR", "Y");
        hashMap.put("CYS", "C");
        hashMap.put("LYS", "K");
        hashMap.put("ARG", "R");
        hashMap.put("HIS", "H");
        hashMap.put("ASP", "D");
        hashMap.put("GLU", "E");
        threeToOneLetter = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put("G", "gly");
        hashMap.put("A", "ala");
        hashMap.put("V", "val");
        hashMap.put("L", "leu");
        hashMap.put("I", "ile");
        hashMap.put("M", "met");
        hashMap.put("P", "pro");
        hashMap.put("F", "phe");
        hashMap.put("W", "trp");
        hashMap.put("S", "ser");
        hashMap.put("T", "thr");
        hashMap.put("N", "asn");
        hashMap.put("Q", "gln");
        hashMap.put("Y", "tyr");
        hashMap.put("C", "cys");
        hashMap.put("K", "lys");
        hashMap.put("R", "arg");
        hashMap.put("H", "his");
        hashMap.put("D", "asp");
        hashMap.put("E", "glu");
        oneToThreeLetter = Collections.unmodifiableMap(hashMap);
    }
}

