/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;

public class AtomState
extends Triple
implements Cloneable {
    Atom atom;
    String serial;
    String altconf = " ";
    float charge = 0.0f;
    float bfactor = 0.0f;
    float occupancy = 0.0f;
    String past80 = "";
    String anisoU = null;

    public AtomState(Atom atom, String string) {
        if (atom == null) {
            throw new NullPointerException("Cannot create a state for a null Atom");
        }
        this.atom = atom;
        this.serial = string;
    }

    public String toString() {
        return this.atom + "[" + this.altconf + "/" + this.serial + "]: " + super.toString() + " B=" + this.bfactor + " Q=" + this.occupancy + " e=" + this.charge;
    }

    public Atom getAtom() {
        return this.atom;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getAltConf() {
        return this.altconf;
    }

    public double getCharge() {
        return this.charge;
    }

    public double getTempFactor() {
        return this.bfactor;
    }

    public double getOccupancy() {
        return this.occupancy;
    }

    public String getPast80() {
        return this.past80;
    }

    public String getAnisoU() {
        return this.anisoU;
    }

    public String getName() {
        return this.atom.getName();
    }

    public String getElement() {
        return this.atom.getElement();
    }

    public Residue getResidue() {
        return this.atom.getResidue();
    }

    public boolean isHet() {
        return this.atom.isHet();
    }

    public void setAltConf(String string) {
        this.altconf = string;
    }

    public void setCharge(double d) {
        this.charge = (float)d;
    }

    public void setTempFactor(double d) {
        this.bfactor = (float)d;
    }

    public void setOccupancy(double d) {
        this.occupancy = (float)d;
    }

    public void setPast80(String string) {
        this.past80 = string;
    }

    public void setAnisoU(String string) {
        this.anisoU = string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone failed unexpectedly");
        }
    }

    public AtomState cloneFor(Atom atom, String string) {
        AtomState atomState = (AtomState)this.clone();
        atomState.atom = atom;
        atomState.serial = string;
        return atomState;
    }

    public AtomState cloneFor(Atom atom) {
        return this.cloneFor(atom, this.getSerial());
    }
}

