/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.data.CheapSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CifSecondaryStructure;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.star.DataBlock;
import driftwood.star.DataCell;
import driftwood.star.StarFile;
import driftwood.star.StarReader;
import driftwood.util.SoftLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class CifReader {
    int numRecords = 0;
    List groupPdb = null;
    List atomSiteId = null;
    List pdbAtomName = null;
    List labelAtomId = null;
    List typeSymbol = null;
    List labelAltId = null;
    List labelCompId = null;
    List labelAsymId = null;
    List labelSeqId = null;
    List labelEntityId = null;
    List pdbInsCode = null;
    List cartnX = null;
    List cartnY = null;
    List cartnZ = null;
    List occupancy = null;
    List bIsoOrEquiv = null;
    List uIsoOrEquiv = null;
    List authSeqId = null;
    List authAsymId = null;
    List pdbModelNum = null;
    String pdbId = null;
    CoordinateFile coordFile = null;
    Map modelMap = null;
    Map states;
    Map resMap = null;
    int fakeResNumber = 1;
    CheapSet stringCache = new CheapSet();
    static final String[] allElementNames = new String[]{"H", "HE", "LI", "BE", "B", "C", "N", "O", "F", "NE", "NA", "MG", "AL", "SI", "P", "S", "CL", "AR", "K", "CA", "SC", "TI", "V", "CR", "MN", "FE", "CO", "NI", "CU", "ZN", "GA", "GE", "AS", "SE", "BR", "KR", "RB", "SR", "Y", "ZR", "NB", "MO", "TC", "RU", "RH", "PD", "AG", "CD", "IN", "SN", "CB", "TE", "I", "XE", "CS", "BA", "LA", "CE", "PR", "ND", "PM", "SM", "EU", "GD", "TB", "DY", "HO", "ER", "TM", "YB", "LU", "HF", "TA", "W", "RE", "OS", "IR", "PT", "AU", "HG", "TL", "PB", "BI", "PO", "AT", "RN", "FR", "RA", "AC", "TH", "PA", "U", "NP", "PU", "AM", "CM", "BK", "CF", "ES", "FM", "MD", "NO", "LR", "RF", "DB", "SG", "BH", "HS", "MT", "DS"};
    static Map elementNames = null;

    String intern(String string) {
        String string2 = (String)this.stringCache.get(string);
        if (string2 == null) {
            this.stringCache.add(string);
            return string;
        }
        return string2;
    }

    public CoordinateFile read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        CoordinateFile coordinateFile = this.read(fileInputStream);
        coordinateFile.setFile(file);
        ((InputStream)fileInputStream).close();
        return coordinateFile;
    }

    public CoordinateFile read(InputStream inputStream) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        inputStream.mark(10);
        if (inputStream.read() == 31 && inputStream.read() == 139) {
            inputStream.reset();
            inputStream = new GZIPInputStream(inputStream);
        } else {
            inputStream.reset();
        }
        return this.read(new InputStreamReader(inputStream));
    }

    public CoordinateFile read(Reader reader) throws IOException {
        try {
            StarFile starFile = new StarReader().parse(new LineNumberReader(reader));
            return this.read(starFile);
        }
        catch (ParseException parseException) {
            throw new IOException("Unable to parse mmCIF file as STAR: " + parseException.getMessage());
        }
    }

    public CoordinateFile read(StarFile starFile) throws IOException {
        Iterator iterator = starFile.getDataBlockNames().iterator();
        if (!iterator.hasNext()) {
            throw new IOException("STAR file has no data blocks");
        }
        DataBlock dataBlock = starFile.getDataBlock((String)iterator.next());
        this.loadItems(dataBlock);
        this.coordFile = new CoordinateFile();
        this.modelMap = new HashMap();
        this.states = new HashMap();
        this.resMap = new HashMap();
        this.fakeResNumber = 1;
        this.stringCache.clear();
        for (int i = 0; i < this.numRecords; ++i) {
            Model model = this.getModel(i);
            Residue residue = this.getResidue(model, i);
            Atom atom = this.getAtom(residue, i);
            AtomState atomState = this.buildAtomState(atom, i);
            ModelState modelState = this.makeState(model, atomState.getAltConf());
            String string = (String)this.labelSeqId.get(i);
            if (modelState.hasState(atom) && (".".equals(string) || "?".equals(string))) {
                ++this.fakeResNumber;
                --i;
                continue;
            }
            try {
                modelState.add(atomState);
                continue;
            }
            catch (AtomException atomException) {
                System.err.println(this.pdbId + " " + model.toString() + " modelstate already contains a state for " + atomState.toString());
            }
        }
        this.coordFile.setSecondaryStructure(new CifSecondaryStructure(dataBlock));
        if (this.pdbId != null) {
            this.coordFile.setIdCode(this.pdbId);
        }
        for (Model model : this.coordFile.getModels()) {
            model.setStates((Map)this.states.get(model));
            try {
                model.fillInStates(false);
            }
            catch (AtomException atomException) {
                SoftLog.err.println("Unable to find states for all atoms in model!");
                atomException.printStackTrace(SoftLog.err);
            }
        }
        return this.coordFile;
    }

    void loadItems(DataCell dataCell) throws IOException {
        this.pdbId = dataCell.getSingleItem("_entry.id");
        this.groupPdb = dataCell.getItem("_atom_site.group_PDB");
        this.atomSiteId = dataCell.getItem("_atom_site.id");
        this.pdbAtomName = dataCell.getItem("_atom_site.pdbx_PDB_atom_name");
        this.labelAtomId = dataCell.getItem("_atom_site.label_atom_id");
        this.typeSymbol = dataCell.getItem("_atom_site.type_symbol");
        this.labelAltId = dataCell.getItem("_atom_site.label_alt_id");
        this.labelCompId = dataCell.getItem("_atom_site.label_comp_id");
        this.labelAsymId = dataCell.getItem("_atom_site.label_asym_id");
        this.labelSeqId = dataCell.getItem("_atom_site.label_seq_id");
        this.labelEntityId = dataCell.getItem("_atom_site.label_entity_id");
        this.pdbInsCode = dataCell.getItem("_atom_site.pdbx_PDB_ins_code");
        this.cartnX = dataCell.getItem("_atom_site.Cartn_x");
        this.cartnY = dataCell.getItem("_atom_site.Cartn_y");
        this.cartnZ = dataCell.getItem("_atom_site.Cartn_z");
        this.occupancy = dataCell.getItem("_atom_site.occupancy");
        this.bIsoOrEquiv = dataCell.getItem("_atom_site.B_iso_or_equiv");
        this.uIsoOrEquiv = dataCell.getItem("_atom_site.U_iso_or_equiv");
        this.authSeqId = dataCell.getItem("_atom_site.auth_seq_id");
        this.authAsymId = dataCell.getItem("_atom_site.auth_asym_id");
        this.pdbModelNum = dataCell.getItem("_atom_site.pdbx_PDB_model_num");
        this.numRecords = this.labelAtomId.size();
        if (this.numRecords == 0 || this.atomSiteId.size() != this.numRecords || this.typeSymbol.size() != this.numRecords || this.labelAltId.size() != this.numRecords || this.labelCompId.size() != this.numRecords || this.labelAsymId.size() != this.numRecords || this.labelSeqId.size() != this.numRecords || this.labelEntityId.size() != this.numRecords || this.cartnX.size() != this.numRecords || this.cartnY.size() != this.numRecords || this.cartnZ.size() != this.numRecords || this.authSeqId.size() != this.numRecords || this.authAsymId.size() != this.numRecords) {
            throw new IOException("Required atom_site data items are missing or disagree in length.");
        }
        if (this.groupPdb.size() == 0) {
            this.groupPdb = null;
        }
        if (this.pdbAtomName.size() == 0) {
            this.pdbAtomName = null;
        }
        if (this.pdbInsCode.size() == 0) {
            this.pdbInsCode = null;
        }
        if (this.occupancy.size() == 0) {
            this.occupancy = null;
        }
        if (this.bIsoOrEquiv.size() == 0) {
            this.bIsoOrEquiv = null;
        }
        if (this.uIsoOrEquiv.size() == 0) {
            this.uIsoOrEquiv = null;
        }
        if (this.pdbModelNum.size() == 0) {
            this.pdbModelNum = null;
        }
    }

    Model getModel(int n) {
        String string = this.pdbModelNum == null ? "1" : (String)this.pdbModelNum.get(n);
        Model model = (Model)this.modelMap.get(string);
        if (model == null) {
            string = this.intern(string);
            model = new Model(string);
            this.modelMap.put(string, model);
            this.coordFile.add(model);
        }
        return model;
    }

    ModelState makeState(Model model, String string) {
        ModelState modelState;
        HashMap<String, ModelState> hashMap = (HashMap<String, ModelState>)this.states.get(model);
        if (hashMap == null) {
            hashMap = new HashMap<String, ModelState>();
            this.states.put(model, hashMap);
        }
        if ((modelState = (ModelState)hashMap.get(string)) == null) {
            modelState = new ModelState();
            if (model != null) {
                modelState.setName(this.coordFile.getIdCode() + " " + model.toString());
            }
            hashMap.put(string, modelState);
            if (!" ".equals(string)) {
                modelState.setParent(this.makeState(model, " "));
            }
        }
        return modelState;
    }

    Residue getResidue(Model model, int n) {
        String string = (String)this.authAsymId.get(n);
        String string2 = (String)this.authSeqId.get(n);
        if (".".equals(string2) || "?".equals(string2)) {
            string2 = Integer.toString(this.fakeResNumber);
        }
        String string3 = ((String)this.labelCompId.get(n)).toUpperCase();
        String string4 = model.getName() + "$" + string + "$" + string2 + "$" + string3;
        Residue residue = (Residue)this.resMap.get(string4);
        if (residue == null) {
            String string5 = " ";
            if (this.pdbInsCode != null && (".".equals(string5 = (String)this.pdbInsCode.get(n)) || "?".equals(string5) || string5.length() == 0)) {
                string5 = " ";
            }
            residue = new Residue(this.intern(string), "", this.intern(string2), this.intern(string5), this.intern(string3));
            this.resMap.put(string4, residue);
            try {
                model.add(residue);
            }
            catch (ResidueException residueException) {
                residueException.printStackTrace();
            }
        }
        return residue;
    }

    Atom getAtom(Residue residue, int n) {
        String string = this.getAtomName(n);
        Atom atom = residue.getAtom(string);
        if (atom == null) {
            String string2 = null;
            if (this.typeSymbol != null) {
                String string3 = (String)this.typeSymbol.get(n);
                string2 = CifReader.getElement(string3 = string3.toUpperCase());
                if (string2 == null && string3.length() > 2) {
                    string3 = string3.substring(0, 2);
                    string2 = CifReader.getElement(string3);
                }
                if (string2 == null && string3.length() > 1) {
                    string3 = string3.substring(0, 1);
                    string2 = CifReader.getElement(string3);
                }
            }
            if (string2 == null) {
                string2 = CifReader.getElement(string.substring(0, 2));
            }
            if (string2 == null) {
                string2 = CifReader.getElement(string.substring(1, 2));
            }
            if (string2 == null) {
                string2 = "XX";
            }
            atom = new Atom(this.intern(string), string2, this.groupPdb == null ? false : ((String)this.groupPdb.get(n)).equals("HETATM"));
            try {
                residue.add(atom);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        return atom;
    }

    String getAtomName(int n) {
        String string;
        if (this.pdbAtomName != null && (string = (String)this.pdbAtomName.get(n)).length() == 4) {
            return string;
        }
        string = (String)this.labelAtomId.get(n);
        int n2 = string.length();
        if (n2 < 1) {
            return "    ";
        }
        if (n2 == 1) {
            return " " + string + "  ";
        }
        if (n2 == 2) {
            if (!Character.isLetter(string.charAt(0))) {
                return string + "  ";
            }
            if (!Character.isLetter(string.charAt(1))) {
                return " " + string + " ";
            }
            if (this.typeSymbol != null && ((String)this.typeSymbol.get(n)).length() == 1) {
                return " " + string + " ";
            }
            if (this.groupPdb != null && ((String)this.groupPdb.get(n)).equals("HETATM")) {
                return string + "  ";
            }
            return " " + string + " ";
        }
        if (n2 == 3) {
            if (!Character.isLetter(string.charAt(0))) {
                return string + " ";
            }
            if (!Character.isLetter(string.charAt(1))) {
                return " " + string;
            }
            if (this.typeSymbol != null && ((String)this.typeSymbol.get(n)).length() == 1) {
                return " " + string;
            }
            if (this.groupPdb != null && ((String)this.groupPdb.get(n)).equals("HETATM")) {
                return string + " ";
            }
            return " " + string;
        }
        if (n2 == 4) {
            return string;
        }
        return string.substring(0, 4);
    }

    static String getElement(String string) {
        if (elementNames == null) {
            elementNames = new HashMap();
            for (int i = 0; i < allElementNames.length; ++i) {
                elementNames.put(allElementNames[i], allElementNames[i]);
            }
            elementNames.put("D", "H");
            elementNames.put("T", "H");
            elementNames.put("Q", "Q");
        }
        return (String)elementNames.get(string);
    }

    AtomState buildAtomState(Atom atom, int n) {
        AtomState atomState = new AtomState(atom, this.intern((String)this.atomSiteId.get(n)));
        if (this.labelAltId != null) {
            String string = (String)this.labelAltId.get(n);
            if (".".equals(string) || "?".equals(string) || string.length() == 0) {
                string = " ";
            }
            atomState.setAltConf(this.intern(string));
        }
        if (this.cartnX != null) {
            try {
                atomState.setX(Double.parseDouble((String)this.cartnX.get(n)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.cartnY != null) {
            try {
                atomState.setY(Double.parseDouble((String)this.cartnY.get(n)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.cartnZ != null) {
            try {
                atomState.setZ(Double.parseDouble((String)this.cartnZ.get(n)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.occupancy != null) {
            try {
                atomState.setOccupancy(Double.parseDouble((String)this.occupancy.get(n)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.bIsoOrEquiv != null) {
            try {
                atomState.setTempFactor(Double.parseDouble((String)this.bIsoOrEquiv.get(n)));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.uIsoOrEquiv != null) {
            try {
                atomState.setTempFactor(78.95683520871486 * Double.parseDouble((String)this.uIsoOrEquiv.get(n)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return atomState;
    }

    public static void main(String[] stringArray) throws IOException {
        CoordinateFile coordinateFile = new CifReader().read(System.in);
        PdbWriter pdbWriter = new PdbWriter(System.out);
        pdbWriter.writeCoordinateFile(coordinateFile, Collections.EMPTY_MAP);
        pdbWriter.close();
    }
}

