/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.data.UberMap;
import driftwood.data.UberSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Disulfides;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Model
implements Cloneable {
    String name;
    UberSet residues;
    Map resCNIT;
    Map chainMap;
    Map segmentMap;
    Map stateMap;
    int modCount = 0;
    Disulfides disulfides;

    public Model(String string) {
        if (string == null) {
            throw new NullPointerException("Must provide a non-null model name");
        }
        this.name = string;
        this.residues = new UberSet();
        this.resCNIT = new HashMap();
        this.chainMap = new UberMap();
        this.segmentMap = new UberMap();
        this.stateMap = new TreeMap();
    }

    public Object clone() {
        try {
            Model model = (Model)super.clone();
            model.residues = new UberSet(model.residues);
            model.resCNIT = new HashMap(model.resCNIT);
            model.chainMap = new UberMap(model.chainMap);
            model.segmentMap = new UberMap(model.segmentMap);
            model.stateMap = new TreeMap(model.stateMap);
            for (Map.Entry entry : model.chainMap.entrySet()) {
                entry.setValue(new UberSet((Set)entry.getValue()));
            }
            for (Map.Entry entry : model.segmentMap.entrySet()) {
                entry.setValue(new UberSet((Set)entry.getValue()));
            }
            return model;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone failed unexpectedly");
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected void modified() {
        ++this.modCount;
    }

    public int getModCount() {
        int n = this.modCount;
        Iterator iterator = this.getResidues().iterator();
        while (iterator.hasNext()) {
            n += ((Residue)iterator.next()).getModCount();
        }
        return n;
    }

    public void add(Residue residue) throws ResidueException {
        if (this.residues.contains(residue)) {
            throw new ResidueException("A residue named " + residue + " is already part of model " + this);
        }
        this.residues.add(residue);
        this.resCNIT.put(residue.getCNIT(), residue);
        this.addToChain(residue, residue.getChain());
        this.addToSegment(residue, residue.getSegment());
        this.modified();
    }

    public void remove(Residue residue) throws ResidueException {
        if (!this.residues.contains(residue)) {
            throw new ResidueException(residue + " is not part of model " + this);
        }
        this.residues.remove(residue);
        this.resCNIT.remove(residue.getCNIT());
        this.removeFromChain(residue, residue.getChain());
        this.removeFromSegment(residue, residue.getSegment());
        this.modified();
    }

    public void replace(Residue residue, Residue residue2) throws ResidueException {
        if (this.residues.contains(residue2)) {
            throw new ResidueException("A residue named " + residue2 + " is already part of model " + this);
        }
        if (!this.residues.contains(residue)) {
            throw new ResidueException(residue + " is not part of model " + this);
        }
        this.resCNIT.remove(residue.getCNIT());
        this.removeFromChain(residue, residue.getChain());
        this.removeFromSegment(residue, residue.getSegment());
        this.resCNIT.put(residue2.getCNIT(), residue2);
        this.addToChain(residue2, residue2.getChain());
        this.addToSegment(residue2, residue2.getSegment());
        this.residues.addBefore(residue, residue2);
        this.residues.remove(residue);
        this.modified();
    }

    public Collection getResidues() {
        return Collections.unmodifiableCollection(this.residues);
    }

    public Residue getResidue(String string) {
        return (Residue)this.resCNIT.get(string);
    }

    public boolean contains(Residue residue) {
        return this.residues.contains(residue);
    }

    public Set getChainIDs() {
        return Collections.unmodifiableSet(this.chainMap.keySet());
    }

    public Set getChain(String string) {
        Set set = (Set)this.chainMap.get(string);
        if (set == null) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    void addToChain(Residue residue, String string) {
        Set set = (Set)this.chainMap.get(string);
        if (set == null) {
            set = new UberSet();
            this.chainMap.put(string, set);
        }
        set.add(residue);
        this.modified();
    }

    void removeFromChain(Residue residue, String string) throws ResidueException {
        Set set = (Set)this.chainMap.get(string);
        if (set == null) {
            throw new ResidueException(residue + " is not a part of non-existant chain " + string);
        }
        if (!set.remove(residue)) {
            throw new ResidueException(residue + " is not a part of chain " + string);
        }
        if (set.isEmpty()) {
            this.chainMap.remove(string);
        }
        this.modified();
    }

    public Set getSegmentIDs() {
        return Collections.unmodifiableSet(this.segmentMap.keySet());
    }

    public Set getSegment(String string) {
        Set set = (Set)this.segmentMap.get(string);
        return Collections.unmodifiableSet(set);
    }

    void addToSegment(Residue residue, String string) {
        Set set = (Set)this.segmentMap.get(string);
        if (set == null) {
            set = new UberSet();
            this.segmentMap.put(string, set);
        }
        set.add(residue);
        this.modified();
    }

    void removeFromSegment(Residue residue, String string) throws ResidueException {
        Set set = (Set)this.segmentMap.get(string);
        if (set == null) {
            throw new ResidueException(residue + " is not a part of non-existant segment " + string);
        }
        if (!set.remove(residue)) {
            throw new ResidueException(residue + " is not a part of segment " + string);
        }
        if (set.isEmpty()) {
            this.segmentMap.remove(string);
        }
        this.modified();
    }

    public Map getStates() {
        return Collections.unmodifiableMap(this.stateMap);
    }

    public ModelState getState(String string) {
        ModelState modelState = (ModelState)this.stateMap.get(string);
        return modelState;
    }

    public ModelState getState() {
        ModelState modelState = this.getState("A");
        if (modelState == null) {
            modelState = this.getState(" ");
        }
        return modelState;
    }

    public void setStates(Map map) {
        this.stateMap = new TreeMap(map);
        this.modified();
    }

    public Disulfides getDisulfides() {
        return this.disulfides;
    }

    public void setDisulfides(Disulfides disulfides) {
        this.disulfides = disulfides;
    }

    public void fillInStates(boolean bl) throws AtomException {
        Collection collection = this.stateMap.values();
        for (Map.Entry entry : this.stateMap.entrySet()) {
            String string = (String)entry.getKey();
            if (" ".equals(string)) continue;
            ModelState modelState = (ModelState)entry.getValue();
            if (bl) {
                entry.setValue(modelState.fillInForModel(this, string, collection));
                continue;
            }
            entry.setValue(modelState.fillInForModel(this, collection));
        }
        this.modified();
    }

    public static Collection extractOrderedStatesByName(Model model) {
        return Model.extractOrderedStatesByName(model.getResidues(), model.getStates().values());
    }

    public static Collection extractOrderedStatesByName(Collection collection, Collection collection2) {
        ModelState[] modelStateArray = collection2.toArray(new ModelState[collection2.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (Residue residue : collection) {
            for (Atom atom : residue.getAtoms()) {
                for (int i = 0; i < modelStateArray.length; ++i) {
                    try {
                        AtomState atomState = modelStateArray[i].get(atom);
                        String string = atomState.getAtom().toString() + atomState.getAltConf();
                        if (hashSet.contains(string)) continue;
                        hashSet.add(string);
                        arrayList.add(atomState);
                        continue;
                    }
                    catch (AtomException atomException) {
                        // empty catch block
                    }
                }
            }
        }
        return arrayList;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Must provide a non-null model name");
        }
        this.name = string;
    }
}

