/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ModelState {
    ModelState parent = null;
    Map stateMap;
    Map unmodMap = null;
    String pdbName = null;

    public ModelState(ModelState modelState, int n) {
        this.parent = modelState;
        if (modelState != null) {
            this.pdbName = modelState.getName();
        }
        this.stateMap = new HashMap(n);
    }

    public ModelState(ModelState modelState) {
        this.parent = modelState;
        if (modelState != null) {
            this.pdbName = modelState.getName();
        }
        this.stateMap = new HashMap();
    }

    public ModelState() {
        this(null);
    }

    public AtomState getLocal(Atom atom) {
        return (AtomState)this.stateMap.get(atom);
    }

    protected AtomState getImpl(Atom atom) {
        AtomState atomState = this.getLocal(atom);
        if (atomState == null && this.parent != null) {
            return this.parent.getImpl(atom);
        }
        return atomState;
    }

    public AtomState get(Atom atom) throws AtomException {
        AtomState atomState = this.getImpl(atom);
        if (atomState == null) {
            throw new AtomException(atom + " has no state specified");
        }
        return atomState;
    }

    public Map getLocalStateMap() {
        if (this.unmodMap == null) {
            this.unmodMap = Collections.unmodifiableMap(this.stateMap);
        }
        return this.unmodMap;
    }

    public boolean hasState(Atom atom) {
        return this.getImpl(atom) != null;
    }

    public void add(AtomState atomState) throws AtomException {
        Atom atom = atomState.getAtom();
        if (this.stateMap.containsKey(atom)) {
            throw new AtomException(this.toString() + " already contains a state for " + atom);
        }
        this.stateMap.put(atom, atomState);
    }

    public AtomState addOverwrite(AtomState atomState) {
        return this.stateMap.put(atomState.getAtom(), atomState);
    }

    public ModelState getParent() {
        return this.parent;
    }

    public void setParent(ModelState modelState) {
        for (ModelState modelState2 = modelState; modelState2 != null; modelState2 = modelState2.getParent()) {
            if (modelState2 != this) continue;
            throw new IllegalArgumentException("Circular inheritance detected");
        }
        this.parent = modelState;
    }

    public String getName() {
        return this.pdbName;
    }

    public void setName(String string) {
        this.pdbName = string;
    }

    public ModelState createCollapsed(ModelState modelState) {
        ModelState modelState2;
        ModelState modelState3 = modelState;
        HashSet<ModelState> hashSet = new HashSet<ModelState>();
        while (modelState != null) {
            hashSet.add(modelState);
            modelState = modelState.getParent();
        }
        int n = 16;
        for (modelState2 = this; modelState2 != null && !hashSet.contains(modelState2); modelState2 = modelState2.getParent()) {
            n = Math.max(n, modelState2.getLocalStateMap().size());
        }
        n = 3 * n / 2;
        ModelState modelState4 = new ModelState(modelState3, n);
        for (modelState2 = this; modelState2 != null && !hashSet.contains(modelState2); modelState2 = modelState2.getParent()) {
            for (Atom atom : modelState2.getLocalStateMap().keySet()) {
                try {
                    if (modelState4.getLocal(atom) != null) continue;
                    modelState4.add(modelState2.getLocal(atom));
                }
                catch (AtomException atomException) {
                    System.err.println("Logical error!");
                    atomException.printStackTrace();
                }
            }
        }
        return modelState4;
    }

    public ModelState createCollapsed() {
        return this.createCollapsed(null);
    }

    public ModelState createForModel(Model model) {
        ModelState modelState = new ModelState();
        for (Residue residue : model.getResidues()) {
            for (Atom atom : residue.getAtoms()) {
                AtomState atomState = this.getImpl(atom);
                try {
                    if (atomState == null) continue;
                    modelState.add(atomState);
                }
                catch (AtomException atomException) {
                    System.err.println("Logical error!");
                    atomException.printStackTrace();
                }
            }
        }
        return modelState;
    }

    public ModelState fillInForModel(Model model, Collection collection) throws AtomException {
        return this.fillInForModel(model, null, collection);
    }

    public ModelState fillInForModel(Model model, String string, Collection collection) throws AtomException {
        ModelState modelState = new ModelState(this);
        ModelState[] modelStateArray = collection.toArray(new ModelState[collection.size()]);
        for (Residue residue : model.getResidues()) {
            for (Atom atom : residue.getAtoms()) {
                AtomState atomState = this.getImpl(atom);
                if (atomState != null) continue;
                for (int i = 0; i < modelStateArray.length && atomState == null; ++i) {
                    atomState = modelStateArray[i].getImpl(atom);
                }
                if (atomState != null) {
                    if (string != null) {
                        atomState = (AtomState)atomState.clone();
                        atomState.setAltConf(string);
                    }
                    try {
                        modelState.add(atomState);
                    }
                    catch (AtomException atomException) {
                        System.err.println("Logical error!");
                        atomException.printStackTrace();
                    }
                    continue;
                }
                throw new AtomException("No state found for " + atom);
            }
        }
        return modelState;
    }

    public String toString() {
        return this.pdbName + " modelstate";
    }

    public String debugStates(int n) {
        Object object;
        Iterator iterator = this.stateMap.keySet().iterator();
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            object = iterator.next();
            Object v = this.stateMap.get(object);
            arrayList.add(object.toString() + " -> " + v.toString());
            if (++n2 != n) continue;
            arrayList.add("truncated...");
            break;
        }
        Collections.sort(arrayList);
        object = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            object = (String)object + string + "\n";
        }
        return object;
    }
}

