/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.util.SoftLog;
import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ModelTreeViewer {
    DefaultMutableTreeNode buildRootNode(CoordinateFile coordinateFile) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("All models", true);
        for (Model model : coordinateFile.getModels()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.buildModelNode(model);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    DefaultMutableTreeNode buildModelNode(Model model) {
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Model " + model, true);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Chains", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (Object object2 : model.getChainIDs()) {
            Iterator iterator = new DefaultMutableTreeNode("Chain '" + (String)object2 + "'", true);
            defaultMutableTreeNode2.add((MutableTreeNode)((Object)iterator));
            for (Iterator iterator2 : model.getChain((String)object2)) {
                Object object3 = this.buildResidueNode((Residue)((Object)iterator2));
                ((DefaultMutableTreeNode)((Object)iterator)).add((MutableTreeNode)object3);
            }
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Segments", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        for (Iterator iterator : model.getSegmentIDs()) {
            Object object4 = new DefaultMutableTreeNode("Segment '" + (String)((Object)iterator) + "'", true);
            defaultMutableTreeNode3.add((MutableTreeNode)object4);
            for (Object object3 : model.getSegment((String)((Object)iterator))) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = this.buildResidueNode((Residue)object3);
                ((DefaultMutableTreeNode)object4).add(defaultMutableTreeNode4);
            }
        }
        object2 = new DefaultMutableTreeNode("All residues", true);
        defaultMutableTreeNode.add((MutableTreeNode)object2);
        for (Object object4 : model.getResidues()) {
            Iterator iterator2;
            iterator2 = this.buildResidueNode((Residue)object4);
            ((DefaultMutableTreeNode)object2).add((MutableTreeNode)((Object)iterator2));
        }
        return defaultMutableTreeNode;
    }

    DefaultMutableTreeNode buildResidueNode(Residue residue) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(residue, true);
        for (Atom atom : residue.getAtoms()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(atom.getName(), false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    CoordinateFile loadCoordinateFile() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(System.in);
        return coordinateFile;
    }

    void launchTreeWindow(TreeNode treeNode) {
        JTree jTree = new JTree(treeNode, true);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jScrollPane);
        JFrame jFrame = new JFrame("Model Tree Viewer");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(jPanel);
        jFrame.setSize(500, 800);
        jFrame.setVisible(true);
    }

    public void Main() {
        try {
            CoordinateFile coordinateFile = this.loadCoordinateFile();
            DefaultMutableTreeNode defaultMutableTreeNode = this.buildRootNode(coordinateFile);
            this.launchTreeWindow(defaultMutableTreeNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            SoftLog.err.println("*** Reading PDB file failed on I/O ***");
        }
    }

    public static void main(String[] stringArray) {
        ModelTreeViewer modelTreeViewer = new ModelTreeViewer();
        try {
            modelTreeViewer.parseArguments(stringArray);
            modelTreeViewer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            SoftLog.err.println();
            modelTreeViewer.showHelp(true);
            SoftLog.err.println();
            SoftLog.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("ModelTreeViewer.help");
            if (inputStream == null) {
                SoftLog.err.println("\n*** Unable to locate help information in 'ModelTreeViewer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        SoftLog.err.println("driftwood.moldb2.ModelTreeViewer");
        SoftLog.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

