/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PdbWriter {
    static final DecimalFormat df2 = Strings.usDecimalFormat("0.00");
    static final DecimalFormat df3 = Strings.usDecimalFormat("0.000");
    PrintWriter out;
    boolean renumberAtoms = false;
    int atomSerial = 1;

    public PdbWriter(OutputStream outputStream) {
        this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public PdbWriter(Writer writer) {
        this.out = new PrintWriter(new BufferedWriter(writer));
    }

    public PdbWriter(File file) throws IOException {
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    public void close() {
        this.out.close();
    }

    public boolean getRenumberAtoms() {
        return this.renumberAtoms;
    }

    public void setRenumberAtoms(boolean bl) {
        this.renumberAtoms = bl;
        this.atomSerial = 1;
    }

    public void writeAtom(AtomState atomState) {
        try {
            Residue residue = atomState.getResidue();
            StringBuffer stringBuffer = new StringBuffer(80);
            if (atomState.isHet()) {
                stringBuffer.append("HETATM");
            } else {
                stringBuffer.append("ATOM  ");
            }
            String string = atomState.getSerial();
            if (this.renumberAtoms) {
                string = Integer.toString(this.atomSerial++);
            }
            stringBuffer.append(Strings.forceRight(string, 5));
            stringBuffer.append(" ");
            stringBuffer.append(Strings.forceLeft(atomState.getName(), 4));
            stringBuffer.append(Strings.forceLeft(atomState.getAltConf(), 1));
            stringBuffer.append(Strings.forceLeft(residue.getName(), 3));
            stringBuffer.append(" ");
            stringBuffer.append(Strings.forceLeft(residue.getChain(), 1));
            stringBuffer.append(Strings.forceRight(residue.getSequenceNumber(), 4));
            stringBuffer.append(Strings.forceLeft(residue.getInsertionCode(), 1));
            stringBuffer.append("   ");
            stringBuffer.append(Strings.forceRight(df3.format(atomState.getX()), 8));
            stringBuffer.append(Strings.forceRight(df3.format(atomState.getY()), 8));
            stringBuffer.append(Strings.forceRight(df3.format(atomState.getZ()), 8));
            stringBuffer.append(Strings.forceRight(df2.format(atomState.getOccupancy()), 6));
            stringBuffer.append(Strings.forceRight(df2.format(atomState.getTempFactor()), 6));
            stringBuffer.append("      ");
            String string2 = residue.getSegment();
            if (string2 == null) {
                string2 = "    ";
            }
            stringBuffer.append(Strings.forceLeft(string2, 4));
            if (atomState.getElement().length() == 1) {
                stringBuffer.append(" " + atomState.getElement());
            } else if (atomState.getElement().length() == 2) {
                stringBuffer.append(atomState.getElement());
            } else {
                stringBuffer.append("  ");
            }
            if (atomState.getCharge() == 0.0) {
                stringBuffer.append("  ");
            } else if (atomState.getCharge() > 0.0) {
                stringBuffer.append((int)atomState.getCharge() + "+");
            } else {
                stringBuffer.append((int)atomState.getCharge() + "-");
            }
            stringBuffer.append(atomState.getPast80());
            this.out.println(stringBuffer);
            this.out.flush();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void writeAnisoU(AtomState atomState) {
        try {
            Residue residue = atomState.getResidue();
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("ANISOU");
            String string = atomState.getSerial();
            if (this.renumberAtoms) {
                string = Integer.toString(this.atomSerial);
            }
            stringBuffer.append(Strings.forceRight(string, 5));
            stringBuffer.append(" ");
            stringBuffer.append(Strings.forceLeft(atomState.getName(), 4));
            stringBuffer.append(Strings.forceLeft(atomState.getAltConf(), 1));
            stringBuffer.append(Strings.forceLeft(residue.getName(), 3));
            stringBuffer.append(" ");
            stringBuffer.append(Strings.forceLeft(residue.getChain(), 1));
            stringBuffer.append(Strings.forceRight(residue.getSequenceNumber(), 4));
            stringBuffer.append(Strings.forceLeft(residue.getInsertionCode(), 1));
            stringBuffer.append("   ");
            stringBuffer.append(atomState.getAnisoU().substring(30));
            this.out.println(stringBuffer);
            this.out.flush();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void writeResidues(Collection collection, ModelState modelState) {
        Object[] objectArray = collection.toArray(new Residue[collection.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Iterator iterator = ((Residue)objectArray[i]).getAtoms().iterator();
            while (iterator.hasNext()) {
                try {
                    Atom atom = (Atom)iterator.next();
                    AtomState atomState = modelState.get(atom);
                    this.writeAtom(atomState);
                    this.writeAnisoU(atomState);
                }
                catch (AtomException atomException) {}
            }
        }
    }

    public void writeCoordinateFile(CoordinateFile coordinateFile) {
        this.writeCoordinateFile(coordinateFile, null);
    }

    public void writeCoordinateFile(CoordinateFile coordinateFile, Map map) {
        Object object2;
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        Iterator iterator = coordinateFile.getHeaders().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().toString();
            if (((String)object2).startsWith("CONECT")) continue;
            this.out.println((String)object2);
        }
        for (Object object2 : coordinateFile.getModels()) {
            Collection collection;
            if (coordinateFile.getModels().size() > 1) {
                this.out.println("MODEL     " + Strings.forceRight(((Model)object2).getName(), 4));
            }
            if ((collection = (Collection)map.get(object2)) == null) {
                collection = ((Model)object2).getStates().values();
            }
            ModelState[] modelStateArray = collection.toArray(new ModelState[collection.size()]);
            this.writeModel((Model)object2, modelStateArray);
            if (coordinateFile.getModels().size() <= 1) continue;
            this.out.println("ENDMDL");
        }
        if (!this.renumberAtoms) {
            iterator = coordinateFile.getHeaders().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next().toString();
                if (!((String)object2).startsWith("CONECT")) continue;
                this.out.println((String)object2);
            }
        }
        this.out.println("END   ");
        this.out.flush();
    }

    private void writeModel(Model model, ModelState[] modelStateArray) {
        HashSet<String> hashSet = new HashSet<String>();
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (residue != null && !residue.getChain().equals(residue2.getChain())) {
                this.writeTerCard(residue);
            }
            residue = residue2;
            for (Atom atom : residue2.getAtoms()) {
                AtomState atomState;
                int n;
                boolean bl = false;
                for (n = 0; n < modelStateArray.length; ++n) {
                    try {
                        atomState = modelStateArray[n].get(atom);
                        if (" ".equals(atomState.getAltConf())) continue;
                        bl = true;
                        break;
                    }
                    catch (AtomException atomException) {
                        // empty catch block
                    }
                }
                for (n = 0; n < modelStateArray.length; ++n) {
                    try {
                        atomState = modelStateArray[n].get(atom);
                        String string = atomState.getAtom().toString() + atomState.getAltConf();
                        if (bl && " ".equals(atomState.getAltConf()) || hashSet.contains(string)) continue;
                        hashSet.add(string);
                        this.writeAtom(atomState);
                        this.writeAnisoU(atomState);
                        continue;
                    }
                    catch (AtomException atomException) {
                        // empty catch block
                    }
                }
            }
        }
        this.writeTerCard(residue);
        this.out.flush();
    }

    private void writeTerCard(Residue residue) {
        StringBuffer stringBuffer = new StringBuffer(27).append("TER   ");
        stringBuffer.append(Strings.forceRight(Integer.toString(this.atomSerial++), 5));
        stringBuffer.append("      ");
        stringBuffer.append(Strings.forceLeft(residue.getName(), 3));
        stringBuffer.append(" ");
        stringBuffer.append(Strings.forceLeft(residue.getChain(), 1));
        stringBuffer.append(Strings.forceRight(residue.getSequenceNumber(), 4));
        stringBuffer.append(Strings.forceLeft(residue.getInsertionCode(), 1));
        this.out.println(stringBuffer);
    }
}

