/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public abstract class SecondaryStructure {
    public static final Object COIL = "Unnamed structure (coil)";
    public static final Object HELIX = "Generic helix";
    public static final Object STRAND = "Generic extended strand";
    public static final Object TURN = "Generic turn";
    public Collection ranges = new ArrayList();

    protected void addRange(Range range) {
        this.ranges.add(range);
        range.rangeIndex = this.ranges.size();
    }

    public Range getRange(Residue residue) {
        for (Range range : this.ranges) {
            if (range.duplicateOf != null || !range.contains(residue)) continue;
            return range;
        }
        return null;
    }

    public Object classify(Residue residue) {
        Range range = this.getRange(residue);
        if (range != null) {
            return range.getType();
        }
        return COIL;
    }

    public boolean isHelix(Residue residue) {
        return HELIX.equals(this.classify(residue));
    }

    public boolean isStrand(Residue residue) {
        return STRAND.equals(this.classify(residue));
    }

    public boolean isTurn(Residue residue) {
        return TURN.equals(this.classify(residue));
    }

    public boolean isCoil(Residue residue) {
        return COIL.equals(this.classify(residue));
    }

    public void consolidateSheets() {
        Hashtable<Integer, Range> hashtable = new Hashtable<Integer, Range>();
        for (Range range : this.ranges) {
            if (!range.type.equals(STRAND)) continue;
            Integer n = new Integer(range.initSeqNum * 1000 + range.chainId.charAt(0));
            if (!hashtable.containsKey(n)) {
                hashtable.put(n, range);
            } else {
                range.duplicateOf = (Range)hashtable.get(n);
            }
            for (Range range2 : this.ranges) {
                if (!range2.type.equals(STRAND) || !range2.sheetID.equals(range.sheetID) || range2.strand != range.strand - 1) continue;
                range.previous = range2;
                range2.next = range;
            }
        }
        for (Range range : this.ranges) {
            if (!range.type.equals(STRAND)) continue;
            if (range.duplicateOf == null && range.next != null && range.next.duplicateOf != null) {
                range.next.duplicateOf.previous = range;
            }
            if (range.duplicateOf != null || range.previous == null || range.previous.duplicateOf == null) continue;
            range.previous = range.previous.duplicateOf;
        }
    }

    public static class Range {
        int rangeIndex = 0;
        Object type = COIL;
        String chainId;
        public int initSeqNum;
        public int endSeqNum;
        String initICode = " ";
        String endICode = " ";
        public int sense = 0;
        public int strand = 1;
        public String sheetID = " ";
        public boolean flipped = false;
        public Range previous = null;
        public Range next = null;
        public Range duplicateOf = null;

        public boolean contains(Residue residue) {
            if (!this.chainId.equals(residue.getChain())) {
                return false;
            }
            int n = residue.getSequenceInteger();
            if (n < this.initSeqNum || n > this.endSeqNum) {
                return false;
            }
            String string = residue.getInsertionCode();
            if (n == this.initSeqNum && string.compareTo(this.initICode) < 0) {
                return false;
            }
            return n != this.endSeqNum || string.compareTo(this.endICode) <= 0;
        }

        public Object getType() {
            return this.type;
        }

        public int getIndex() {
            return this.rangeIndex;
        }
    }

    public static class AllCoil
    extends SecondaryStructure {
        public Object classify(Residue residue) {
            return COIL;
        }
    }
}

