/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.data.UberSet;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Residue;
import driftwood.moldb2.selection.SelectionParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public abstract class Selection {
    private boolean initialized = false;

    protected Selection() {
    }

    public static Selection fromString(String string) throws ParseException {
        try {
            SelectionParser selectionParser = new SelectionParser();
            return selectionParser.parse(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void init(Collection collection, CoordinateFile coordinateFile) {
        this.initialized = true;
    }

    public final boolean select(AtomState atomState) {
        if (!this.initialized) {
            throw new IllegalStateException("Selection must be initialized with init() before use!");
        }
        return this.selectImpl(atomState);
    }

    protected abstract boolean selectImpl(AtomState var1);

    public Collection selectAtomStates(Collection collection) {
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (AtomState atomState : collection) {
            if (!this.select(atomState)) continue;
            arrayList.add(atomState);
        }
        return arrayList;
    }

    public Set selectResidues(Collection collection) {
        UberSet uberSet = new UberSet();
        for (AtomState atomState : collection) {
            Residue residue = atomState.getResidue();
            if (uberSet.contains(residue) || !this.select(atomState)) continue;
            uberSet.add(residue);
        }
        return uberSet;
    }
}

