/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.data.UberSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jiffiloop.FragFiller;
import jiffiloop.PdbFileAnalyzer;
import jiffiloop.PdbLibraryReader;
import jiffiloop.ProteinGap;
import jiffiloop.ProteinStem;
import jiffiloop.StemFiller;
import molikin.Quickin;
import molikin.logic.BallAndStickLogic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLMain {
    static final DecimalFormat df = new DecimalFormat("0.000");
    static HashMap<Integer, Integer> simulatedGaps;
    PdbLibraryReader libReader;
    static File fragLibrary;
    static File pdbLibrary;
    static int matchDiff;
    static boolean ntermsup;
    static boolean useStems;
    static boolean renumber;
    boolean keepSequence = false;
    int fragmentLimit = 100;
    double distanceRange = Double.NaN;
    double nAngleRange = Double.NaN;
    double cAngleRange = Double.NaN;
    double nDihedRange = Double.NaN;
    double dDihedRange = Double.NaN;
    double cDihedRange = Double.NaN;

    public static void main(String[] stringArray) {
        JLMain jLMain = new JLMain();
        simulatedGaps = new HashMap();
        try {
            ArrayList arrayList = jLMain.parseArgs(stringArray);
            File file = new File((String)arrayList.get(0));
            File file2 = new File((String)arrayList.get(1));
            jLMain.runAnalysis(new File(file.getAbsolutePath()), file2.getAbsolutePath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            jLMain.showHelp(true);
            System.exit(0);
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("jiffiloop.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'jiffiloop.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("jiffiloop.JLMain " + this.getVersion("version") + " " + this.getVersion("buildnum"));
        System.err.println("Copyright (C) 2007-2010 by Vincent B. Chen. All rights reserved.");
    }

    void showChanges(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("jiffiloop.changes");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate changes information in 'jiffiloop.changes' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.print("jiffiloop.JLMain " + this.getVersion("version") + " " + this.getVersion("buildnum"));
        System.err.println();
        System.err.println("Copyright (C) 2007-2009 by Vincent B. Chen. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public String getVersion(String string) {
        String string2 = "";
        InputStream inputStream = this.getClass().getResourceAsStream(string + ".props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate changes information in '" + string + ".props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    if (!string3.startsWith("#")) {
                        string2 = string3;
                    }
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string2;
    }

    public ArrayList parseArgs(String[] stringArray) throws IllegalArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Not enough arguments: you must have an input pdb and an output prefix!");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-h") || string.equals("-help")) {
                    this.showHelp(true);
                    System.exit(0);
                    continue;
                }
                if (string.equals("-libloc") || string.equals("-librarylocation")) {
                    if (i + 1 < stringArray.length) {
                        fragLibrary = new File(stringArray[i + 1]);
                        if (!fragLibrary.canRead()) {
                            throw new IllegalArgumentException("Invalid input for fragment library location");
                        }
                        ++i;
                        continue;
                    }
                    throw new IllegalArgumentException("No argument given for fragment library location");
                }
                if (string.equals("-pdbloc") || string.equals("-pdblocation")) {
                    if (i + 1 < stringArray.length) {
                        pdbLibrary = new File(stringArray[i + 1]);
                        if (!pdbLibrary.canRead()) {
                            throw new IllegalArgumentException("Invalid input for pdb library location");
                        }
                        ++i;
                        continue;
                    }
                    throw new IllegalArgumentException("No argument given for pdb library location");
                }
                if (string.equals("-nomatchsize")) {
                    if (i + 1 < stringArray.length) {
                        if (JLMain.isInteger(stringArray[i + 1])) {
                            matchDiff = Integer.parseInt(stringArray[i + 1]);
                            ++i;
                            continue;
                        }
                        throw new IllegalArgumentException("No integer given for -nomatchsize");
                    }
                    throw new IllegalArgumentException("No integer given for -nomatchsize");
                }
                if (string.equals("-fragments")) {
                    if (i + 1 < stringArray.length) {
                        if (JLMain.isInteger(stringArray[i + 1])) {
                            this.fragmentLimit = Integer.parseInt(stringArray[i + 1]);
                            ++i;
                            continue;
                        }
                        throw new IllegalArgumentException("No integer given for -fragments");
                    }
                    throw new IllegalArgumentException("No integer given for -fragments");
                }
                if (string.equals("-ntermsup")) {
                    ntermsup = true;
                    continue;
                }
                if (string.equals("-stems") || string.equals("-stem")) {
                    useStems = true;
                    continue;
                }
                if (string.equals("-norenumber")) {
                    renumber = false;
                    continue;
                }
                if (string.equals("-sequence")) {
                    this.keepSequence = true;
                    continue;
                }
                if (string.equals("-tighter")) {
                    if (Double.isNaN(this.distanceRange)) {
                        this.distanceRange = 0.5;
                    }
                    if (Double.isNaN(this.nAngleRange)) {
                        this.nAngleRange = 15.0;
                    }
                    if (Double.isNaN(this.cAngleRange)) {
                        this.cAngleRange = 15.0;
                    }
                    if (Double.isNaN(this.nDihedRange)) {
                        this.nDihedRange = 10.0;
                    }
                    if (Double.isNaN(this.dDihedRange)) {
                        this.dDihedRange = 10.0;
                    }
                    if (!Double.isNaN(this.cDihedRange)) continue;
                    this.cDihedRange = 10.0;
                    continue;
                }
                if (string.equals("-distancerange")) {
                    if (i + 1 < stringArray.length) {
                        if (JLMain.isNumber(stringArray[i + 1])) {
                            this.distanceRange = Double.parseDouble(stringArray[i + 1]);
                            ++i;
                            continue;
                        }
                        throw new IllegalArgumentException("No number given for -distancerange");
                    }
                    throw new IllegalArgumentException("No number given for -distancerange");
                }
                if (string.equals("-angleranges")) {
                    if (i + 2 < stringArray.length) {
                        if (JLMain.isNumber(stringArray[i + 1]) && JLMain.isNumber(stringArray[i + 2])) {
                            this.nAngleRange = Double.parseDouble(stringArray[i + 1]);
                            this.cAngleRange = Double.parseDouble(stringArray[i + 2]);
                            i += 2;
                            continue;
                        }
                        throw new IllegalArgumentException("Two numbers needed for -angleranges");
                    }
                    throw new IllegalArgumentException("Two numbers needed for -angleranges");
                }
                if (string.equals("-dihedralranges")) {
                    if (i + 3 < stringArray.length) {
                        if (JLMain.isNumber(stringArray[i + 1]) && JLMain.isNumber(stringArray[i + 2]) && JLMain.isNumber(stringArray[i + 3])) {
                            this.nDihedRange = Double.parseDouble(stringArray[i + 1]);
                            this.dDihedRange = Double.parseDouble(stringArray[i + 2]);
                            this.cDihedRange = Double.parseDouble(stringArray[i + 3]);
                            i += 3;
                            continue;
                        }
                        throw new IllegalArgumentException("Three numbers needed for -dihedralranges");
                    }
                    throw new IllegalArgumentException("Three numbers needed for -dihedralranges");
                }
                throw new IllegalArgumentException("*** Unrecognized option: " + string);
            }
            if (string.matches("[0-9]*-[0-9]*")) {
                int n;
                String[] stringArray2 = string.split("-");
                int n2 = Integer.parseInt(stringArray2[0]);
                if (n2 > (n = Integer.parseInt(stringArray2[1]))) {
                    simulatedGaps.put(n, n2);
                    continue;
                }
                if (n > n2) {
                    simulatedGaps.put(n2, n);
                    continue;
                }
                throw new IllegalArgumentException("You are trying to simulate a gap of size zero!");
            }
            System.out.println(string);
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setDefaults() {
        String string = System.getProperty("user.dir").substring(0, System.getProperty("user.dir").indexOf("labwork") + 7);
        if (fragLibrary == null) {
            fragLibrary = new File(string + "/loopwork/fragfiller/");
        }
        if (pdbLibrary == null) {
            pdbLibrary = new File(string + "/loopwork/fragfiller/pdblibrary");
        }
        if (matchDiff < 0) {
            matchDiff = 0;
        }
        if (Double.isNaN(this.distanceRange)) {
            this.distanceRange = 1.0;
        }
        if (Double.isNaN(this.nAngleRange)) {
            this.nAngleRange = 25.0;
        }
        if (Double.isNaN(this.cAngleRange)) {
            this.cAngleRange = 25.0;
        }
        if (Double.isNaN(this.nDihedRange)) {
            this.nDihedRange = 25.0;
        }
        if (Double.isNaN(this.dDihedRange)) {
            this.dDihedRange = 25.0;
        }
        if (Double.isNaN(this.cDihedRange)) {
            this.cDihedRange = 25.0;
        }
    }

    public void runAnalysis(File file, String string) {
        CoordinateFile[] coordinateFileArray;
        Object object;
        Object object2;
        this.setDefaults();
        PdbFileAnalyzer pdbFileAnalyzer = new PdbFileAnalyzer(file);
        pdbFileAnalyzer.analyzePdb();
        for (Integer object32 : simulatedGaps.keySet()) {
            object2 = simulatedGaps.get(object32);
            pdbFileAnalyzer.simulateGap(object32, (Integer)object2, useStems);
        }
        this.libReader = new PdbLibraryReader(pdbLibrary, renumber, !this.keepSequence);
        Map<String, ArrayList<ProteinGap>> map = pdbFileAnalyzer.getGaps();
        object2 = string;
        if (!useStems) {
            Object object3;
            for (Object stemFiller : map.values()) {
                Object arrayList = ((ArrayList)stemFiller).iterator();
                while (arrayList.hasNext()) {
                    object3 = (ProteinGap)arrayList.next();
                    System.out.println(object3);
                    if (((ProteinGap)object3).getSize() <= 15) continue;
                    ((ArrayList)stemFiller).remove(object3);
                }
            }
            object = new FragFiller(map);
            for (Object arrayList : map.values()) {
                object3 = ((ArrayList)arrayList).iterator();
                while (object3.hasNext()) {
                    ProteinGap proteinGap = (ProteinGap)object3.next();
                    object2 = (String)object2 + "." + proteinGap.getResidueRange();
                }
            }
            ((FragFiller)object).searchDB(matchDiff, this.distanceRange, this.nAngleRange, this.cAngleRange, this.nDihedRange, this.dDihedRange, this.cDihedRange);
            System.out.println(((FragFiller)object).getMatchesInfo());
            coordinateFileArray = ((FragFiller)object).getFragments(this.libReader, ntermsup, this.fragmentLimit);
        } else {
            object = pdbFileAnalyzer.getStems();
            StemFiller stemFiller = new StemFiller((Map<String, ArrayList<ProteinStem>>)object);
            ArrayList arrayList = new ArrayList();
            stemFiller.searchDB(matchDiff);
            System.out.println(stemFiller.getMatchesInfo());
            coordinateFileArray = stemFiller.getFragments(this.libReader, ntermsup, this.fragmentLimit);
        }
        this.writePdbs(coordinateFileArray, string);
        object = new File((String)object2 + ".kin");
        System.out.println("Writing kin to " + ((File)object).toString());
        this.writeKin(pdbFileAnalyzer.getCoordFile(), coordinateFileArray, (File)object);
    }

    public ArrayList<File> getFrameDataList() {
        System.out.println(fragLibrary);
        File[] fileArray = fragLibrary.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (!file.getName().endsWith(".zip")) continue;
            arrayList.add(file);
            System.out.println(file);
        }
        return arrayList;
    }

    public void writePdbs(CoordinateFile[] coordinateFileArray, String string) {
        for (CoordinateFile coordinateFile : coordinateFileArray) {
            try {
                File file = new File(string + coordinateFile.getIdCode() + ".pdb");
                System.out.println("Writing pdb to " + file.toString());
                PdbWriter pdbWriter = new PdbWriter(file);
                pdbWriter.writeCoordinateFile(coordinateFile);
                pdbWriter.close();
            }
            catch (IOException iOException) {
                System.err.println("An error occurred while saving a pdb." + iOException);
            }
        }
    }

    public void writeKin(CoordinateFile coordinateFile, CoordinateFile[] coordinateFileArray, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(fileWriter));
            printWriter.println("@kinemage");
            BallAndStickLogic ballAndStickLogic = Quickin.getLotsLogic();
            for (Object object : coordinateFile.getModels()) {
                printWriter.println("@group {" + coordinateFile.getIdCode() + " " + ((Model)object).getName() + "} dominant master= {input pdb}");
                ballAndStickLogic.printKinemage(printWriter, (Model)object, new UberSet(((Model)object).getResidues()), coordinateFile.getIdCode(), "bluetint");
            }
            for (CoordinateFile coordinateFile2 : coordinateFileArray) {
                for (Model model : coordinateFile2.getModels()) {
                    printWriter.println("@group {" + model.getName() + " " + coordinateFile2.getIdCode() + "} dominant animate master= {all models}");
                    Residue[] residueArray = model.getResidues().toArray(new Residue[0]);
                    String string = this.getPast80Info(residueArray[0], model);
                    String string2 = this.getPast80Info(residueArray[residueArray.length - 1], model);
                    string2 = string2.substring(string2.lastIndexOf("_") + 1);
                    ballAndStickLogic.printKinemage(printWriter, model, new UberSet(model.getResidues()), string + "-" + string2, "white");
                }
            }
            printWriter.flush();
            ((Writer)fileWriter).close();
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while saving the kin." + iOException);
        }
    }

    public String getPast80Info(Residue residue, Model model) {
        ModelState modelState = model.getState();
        try {
            Atom atom = residue.getAtom(" CA ");
            if (atom != null) {
                AtomState atomState = modelState.get(atom);
                return atomState.getPast80().trim();
            }
            System.err.println("CA not found in fragment, this shouldn't happen!");
        }
        catch (AtomException atomException) {
            System.err.println("CA not found in fragment, this shouldn't happen!\n");
            atomException.printStackTrace();
        }
        return "";
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    static {
        fragLibrary = null;
        pdbLibrary = null;
        ntermsup = false;
        useStems = false;
        renumber = true;
    }
}

