/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.data.UberSet;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import jiffiloop.ProteinGap;
import jiffiloop.ProteinStem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdbFileAnalyzer {
    CoordinateFile pdbFile;
    HashMap<Model, HashMap<String, ArrayList>> masterGapMap = new HashMap();
    HashMap<Model, HashMap<String, ArrayList>> masterStemMap = new HashMap();

    public PdbFileAnalyzer(File file) {
        PdbReader pdbReader = new PdbReader();
        try {
            this.pdbFile = pdbReader.read(file);
            this.pdbFile.setIdCode(file.getName());
        }
        catch (IOException iOException) {
            System.err.println("Problem when reading pdb file");
        }
    }

    public void clear() {
        this.masterGapMap = new HashMap();
        this.masterStemMap = new HashMap();
    }

    public void analyzePdb() {
        for (Model model : this.pdbFile.getModels()) {
            this.masterGapMap.put(model, this.analyzeModelforGaps(model));
            this.masterStemMap.put(model, this.analyzeModelforStems(model));
        }
    }

    public HashMap<String, ArrayList> analyzeModelforGaps(Model model) {
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        Set set = model.getChainIDs();
        for (String string : set) {
            Set set2 = model.getChain(string);
            hashMap.put(string, this.findGaps(model, string, set2));
        }
        return hashMap;
    }

    public HashMap<String, ArrayList> analyzeModelforStems(Model model) {
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        Set set = model.getChainIDs();
        for (String string : set) {
            Set set2 = model.getChain(string);
            hashMap.put(string, this.findStems(model, string, set2));
        }
        return hashMap;
    }

    public Set<Residue> removeBadRes(Set<Residue> set) {
        UberSet uberSet = new UberSet();
        for (Residue residue : set) {
            if (!this.containsCaO(residue)) continue;
            uberSet.add(residue);
        }
        return uberSet;
    }

    public ArrayList<ProteinStem> findStems(Model model, String string, Set<Residue> set) {
        int n = 100000;
        UberSet uberSet = new UberSet(set);
        ArrayList<ProteinStem> arrayList = new ArrayList<ProteinStem>();
        for (Residue residue : set) {
            int n2 = residue.getSequenceInteger();
            if (n2 > n + 1) {
                ProteinStem proteinStem;
                Residue residue2;
                Residue residue3;
                Residue residue4;
                ArrayList arrayList2 = new ArrayList();
                try {
                    residue4 = (Residue)uberSet.itemBefore(residue);
                    residue3 = (Residue)uberSet.itemBefore(residue4);
                    residue2 = (Residue)uberSet.itemBefore(residue3);
                    while (!(this.containsCaO(residue2) || this.containsCaO(residue3) || this.containsCa(residue4))) {
                        residue4 = (Residue)uberSet.itemBefore(residue4);
                        residue3 = (Residue)uberSet.itemBefore(residue4);
                        residue2 = (Residue)uberSet.itemBefore(residue3);
                    }
                    proteinStem = new ProteinStem(model, string, residue2, residue3, residue4, 1);
                    arrayList.add(proteinStem);
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.out.println("No nterm stem possible for " + residue.toString());
                }
                try {
                    residue4 = residue;
                    residue3 = (Residue)uberSet.itemAfter(residue4);
                    residue2 = (Residue)uberSet.itemAfter(residue3);
                    while (!(this.containsCaO(residue4) || this.containsCaO(residue3) || this.containsCa(residue2))) {
                        residue4 = (Residue)uberSet.itemAfter(residue4);
                        residue3 = (Residue)uberSet.itemAfter(residue4);
                        residue2 = (Residue)uberSet.itemAfter(residue3);
                    }
                    proteinStem = new ProteinStem(model, string, residue4, residue3, residue2, 2);
                    arrayList.add(proteinStem);
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.out.println("No cterm stem possible for " + residue.toString());
                }
            }
            n = n2;
        }
        return arrayList;
    }

    public Map<String, ArrayList<ProteinStem>> getStems() {
        TreeMap<String, ArrayList<ProteinStem>> treeMap = new TreeMap<String, ArrayList<ProteinStem>>();
        for (Model model : this.masterStemMap.keySet()) {
            Map map = this.masterStemMap.get(model);
            for (String string : map.keySet()) {
                ArrayList arrayList = (ArrayList)map.get(string);
                treeMap.put(model.getName() + "," + string, arrayList);
            }
        }
        return treeMap;
    }

    public ArrayList<ProteinGap> findGaps(Model model, String string, Set<Residue> set) {
        int n = 100000;
        UberSet uberSet = new UberSet(set);
        ArrayList<ProteinGap> arrayList = new ArrayList<ProteinGap>();
        for (Residue residue : set) {
            int n2 = residue.getSequenceInteger();
            if (this.hasProteinBB(residue) && n2 > n + 1) {
                ArrayList arrayList2 = new ArrayList();
                Residue residue2 = (Residue)uberSet.itemBefore(residue);
                Residue residue3 = (Residue)uberSet.itemBefore(residue2);
                while (!this.containsCaO(residue3) && !this.containsCa(residue2)) {
                    residue2 = (Residue)uberSet.itemBefore(residue2);
                    residue3 = (Residue)uberSet.itemBefore(residue2);
                }
                Residue residue4 = residue;
                Residue residue5 = (Residue)uberSet.itemAfter(residue4);
                while (!this.containsCaO(residue4) && !this.containsCa(residue5)) {
                    residue4 = (Residue)uberSet.itemAfter(residue4);
                    residue5 = (Residue)uberSet.itemAfter(residue4);
                }
                ProteinGap proteinGap = new ProteinGap(model, string, residue3, residue2, residue4, residue5);
                arrayList.add(proteinGap);
            }
            n = n2;
        }
        return arrayList;
    }

    public void simulateGap(int n, int n2, boolean bl) {
        for (Model model : this.pdbFile.getModels()) {
            HashMap<String, ArrayList<Object>> hashMap;
            HashMap<String, ArrayList<Object>> hashMap2 = this.masterGapMap.get(model);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this.masterGapMap.put(model, hashMap2);
            }
            if ((hashMap = this.masterStemMap.get(model)) == null) {
                hashMap = new HashMap();
                this.masterStemMap.put(model, hashMap);
            }
            Set set = model.getChainIDs();
            for (String string : set) {
                ArrayList<Object> arrayList;
                ArrayList<Object> arrayList2 = hashMap2.get(string);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                    hashMap2.put(string, arrayList2);
                }
                if ((arrayList = hashMap.get(string)) == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string, arrayList);
                }
                Set set2 = model.getChain(string);
                Residue residue = null;
                Residue residue2 = null;
                Residue residue3 = null;
                Residue residue4 = null;
                Residue residue5 = null;
                Residue residue6 = null;
                Residue residue7 = null;
                for (Residue residue8 : set2) {
                    int n3 = residue8.getSequenceInteger();
                    if (n3 == n - 2 && this.containsCaO(residue8)) {
                        residue = residue8;
                    }
                    if (n3 == n - 1 && this.containsCaO(residue8)) {
                        residue2 = residue8;
                    }
                    if (n3 == n && this.containsCa(residue8)) {
                        residue3 = residue8;
                    }
                    if (n3 == n2 && this.containsCaO(residue8)) {
                        residue4 = residue8;
                    }
                    if (n3 == n2 + 1 && this.containsCa(residue8)) {
                        residue5 = residue8;
                    }
                    if (n3 == n2 + 1 && this.containsCaO(residue8)) {
                        residue6 = residue8;
                    }
                    if (n3 != n2 + 2 || !this.containsCa(residue8)) continue;
                    residue7 = residue8;
                }
                if (residue2 != null && residue3 != null && residue4 != null && residue5 != null) {
                    arrayList2.add(new ProteinGap(model, string, residue2, residue3, residue4, residue5));
                }
                if (!bl) continue;
                if (residue != null && residue2 != null && residue3 != null) {
                    arrayList.add(new ProteinStem(model, string, residue, residue2, residue3, 1));
                }
                if (residue4 == null || residue6 == null || residue7 == null) continue;
                arrayList.add(new ProteinStem(model, string, residue4, residue6, residue7, 2));
            }
        }
    }

    public Map<String, ArrayList<ProteinGap>> getGaps() {
        TreeMap<String, ArrayList<ProteinGap>> treeMap = new TreeMap<String, ArrayList<ProteinGap>>();
        for (Model model : this.masterGapMap.keySet()) {
            Map map = this.masterGapMap.get(model);
            for (String string : map.keySet()) {
                ArrayList arrayList = (ArrayList)map.get(string);
                treeMap.put(model.getName() + "," + string, arrayList);
            }
        }
        return treeMap;
    }

    public boolean containsCaO(Residue residue) {
        if (residue == null) {
            return false;
        }
        return residue.getAtom(" CA ") != null && residue.getAtom(" O  ") != null;
    }

    public boolean containsCa(Residue residue) {
        if (residue == null) {
            return false;
        }
        return residue.getAtom(" CA ") != null;
    }

    public boolean hasProteinBB(Residue residue) {
        if (residue == null) {
            return false;
        }
        return residue.getAtom(" CA ") != null && residue.getAtom(" O  ") != null && residue.getAtom(" N  ") != null && residue.getAtom(" C  ") != null;
    }

    public CoordinateFile getCoordFile() {
        return this.pdbFile;
    }

    public void test() {
        for (Map map : this.masterGapMap.values()) {
            for (String string : map.keySet()) {
                System.out.println(string);
                ArrayList arrayList = (ArrayList)map.get(string);
            }
        }
    }
}

