/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.data.CheapSet;
import driftwood.data.IdentityHashFunction;
import driftwood.moldb2.AtomState;
import java.util.Collection;
import java.util.Set;
import molikin.ResClassifier;
import molikin.Util;

public class AtomClassifier {
    Collection atomStates;
    ResClassifier resClassifier;
    public Set mcHeavy = new CheapSet(new IdentityHashFunction());
    public int mcNotCa = 0;
    public Set mcHydro = new CheapSet(new IdentityHashFunction());
    public Set scHeavy = new CheapSet(new IdentityHashFunction());
    public Set scHydro = new CheapSet(new IdentityHashFunction());
    public Set watHeavy = new CheapSet(new IdentityHashFunction());
    public Set watHydro = new CheapSet(new IdentityHashFunction());
    public Set metal = new CheapSet(new IdentityHashFunction());
    public Set hetHeavy = new CheapSet(new IdentityHashFunction());
    public Set hetHydro = new CheapSet(new IdentityHashFunction());
    public Set bioHeavy = new CheapSet(new IdentityHashFunction());

    public AtomClassifier(Collection collection, ResClassifier resClassifier) {
        this.atomStates = collection;
        this.resClassifier = resClassifier;
        for (AtomState atomState : collection) {
            Object object = resClassifier.classify(atomState.getResidue());
            boolean bl = atomState.getElement().equals("H");
            if (object == ResClassifier.PROTEIN || object == ResClassifier.NUCACID) {
                if (Util.isMainchain(atomState)) {
                    if (bl) {
                        this.mcHydro.add(atomState);
                        continue;
                    }
                    this.mcHeavy.add(atomState);
                    if (atomState.getName().equals(" CA ")) continue;
                    ++this.mcNotCa;
                    continue;
                }
                if (bl) {
                    this.scHydro.add(atomState);
                    continue;
                }
                this.scHeavy.add(atomState);
                continue;
            }
            if (object == ResClassifier.WATER) {
                if (bl) {
                    this.watHydro.add(atomState);
                    continue;
                }
                this.watHeavy.add(atomState);
                continue;
            }
            if (object == ResClassifier.METAL) {
                this.metal.add(atomState);
                continue;
            }
            if (bl) {
                this.hetHydro.add(atomState);
                continue;
            }
            this.hetHeavy.add(atomState);
        }
        this.bioHeavy.addAll(this.mcHeavy);
        this.bioHeavy.addAll(this.scHeavy);
    }
}

