/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.data.CheapSet;
import driftwood.data.FinalArrayList;
import driftwood.moldb2.AtomState;
import driftwood.r3.SpatialBin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import molikin.Bond;
import molikin.Util;

public class AtomGraph {
    AtomState[] atomStates;
    Map stateIndices;
    SpatialBin stateBin;
    Collection[] covNeighbors;
    Collection allBonds = null;
    Collection unbondedAtoms = null;
    boolean ignoreChains = false;
    private ArrayList _hits1 = new ArrayList();
    private ArrayList _hits2 = new ArrayList();

    public AtomGraph(Collection collection) {
        int n;
        this.atomStates = collection.toArray(new AtomState[collection.size()]);
        this.stateIndices = new IdentityHashMap(this.atomStates.length);
        for (n = 0; n < this.atomStates.length; ++n) {
            this.stateIndices.put(this.atomStates[n], new Integer(n));
        }
        this.stateBin = new SpatialBin(3.0);
        this.stateBin.addAll(Arrays.asList(this.atomStates));
        this.covNeighbors = new Collection[this.atomStates.length];
        for (n = 0; n < this.covNeighbors.length; ++n) {
            this.covNeighbors[n] = null;
        }
    }

    public Collection getBonds() {
        if (this.allBonds == null) {
            this.allBonds = new CheapSet();
            this.unbondedAtoms = new ArrayList();
            for (int i = 0; i < this.atomStates.length; ++i) {
                AtomState atomState = this.atomStates[i];
                Collection collection = this.getNeighbors(atomState);
                if (collection.size() == 0) {
                    this.unbondedAtoms.add(atomState);
                    continue;
                }
                int n = (Integer)this.stateIndices.get(atomState);
                for (AtomState atomState2 : collection) {
                    int n2 = (Integer)this.stateIndices.get(atomState2);
                    this.allBonds.add(new Bond(atomState, n, atomState2, n2));
                }
            }
            Object[] objectArray = this.allBonds.toArray();
            this.allBonds = null;
            Arrays.sort(objectArray);
            this.allBonds = new FinalArrayList(objectArray);
            this.unbondedAtoms = Collections.unmodifiableCollection(this.unbondedAtoms);
        }
        return this.allBonds;
    }

    public Collection getUnbonded() {
        if (this.unbondedAtoms == null) {
            this.getBonds();
        }
        return this.unbondedAtoms;
    }

    public Collection getNeighbors(AtomState atomState) {
        int n = (Integer)this.stateIndices.get(atomState);
        Collection collection = this.covNeighbors[n];
        if (collection == null) {
            String string = atomState.getElement();
            collection = string.equals("H") ? this.connectHydrogens(atomState) : this.connectHeavyAtoms(atomState);
            this.covNeighbors[n] = collection;
        }
        return collection;
    }

    private Collection connectHydrogens(AtomState atomState) {
        this._hits2.clear();
        this.stateBin.findSphere(atomState, 2.0, this._hits2);
        AtomState atomState2 = null;
        double d = Double.POSITIVE_INFINITY;
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>(1);
        for (AtomState atomState3 : this._hits2) {
            boolean bl;
            String string;
            if (atomState3 == atomState || (string = atomState3.getElement()).equals("H") || string.equals("Q")) continue;
            boolean bl2 = bl = this.ignoreChains || atomState.getResidue().getChain().equals(atomState3.getResidue().getChain());
            double d2 = atomState.sqDistance(atomState3);
            if (!(d2 <= 4.0) || !(d2 < d) || !bl || !Util.altsAreCompatible(atomState, atomState3)) continue;
            atomState2 = atomState3;
            d = d2;
        }
        if (atomState2 != null) {
            arrayList.add(atomState2);
        }
        return arrayList;
    }

    private Collection connectHeavyAtoms(AtomState atomState) {
        double d;
        double d2;
        boolean bl;
        this._hits1.clear();
        String string = atomState.getElement();
        boolean bl2 = string.equals("C") || string.equals("N") || string.equals("O");
        boolean bl3 = bl = bl2 || string.equals("P");
        if (bl2) {
            d2 = 4.0;
            d = 4.840000000000001;
            this.stateBin.findSphere(atomState, 2.2, this._hits1);
        } else {
            d2 = 4.840000000000001;
            d = 6.25;
            this.stateBin.findSphere(atomState, 2.5, this._hits1);
        }
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>(Math.min(4, this._hits1.size()));
        for (AtomState atomState2 : this._hits1) {
            if (atomState2 == atomState) continue;
            String string2 = atomState2.getElement();
            if (string2.equals("H")) {
                Collection collection = this.getNeighbors(atomState2);
                if (collection.size() < 1 || collection.iterator().next() != atomState) continue;
                arrayList.add(atomState2);
                continue;
            }
            boolean bl4 = string2.equals("C") || string2.equals("N") || string2.equals("O");
            boolean bl5 = this.ignoreChains || atomState.getResidue().getChain().equals(atomState2.getResidue().getChain()) || atomState.isHet() || atomState2.isHet() || !bl || !bl4 && !string2.equals("P");
            boolean bl6 = true;
            if (!Util.isMainchain(atomState) & !Util.isMainchain(atomState2)) {
                bl6 = atomState.getResidue().equals(atomState2.getResidue());
            }
            boolean bl7 = atomState.getElement().equals("S") && atomState2.getElement().equals("S") && !bl6;
            double d3 = bl4 ? d2 : d;
            if (!(atomState.sqDistance(atomState2) <= d3) || !bl5 || !Util.altsAreCompatible(atomState, atomState2) || !bl6 && !bl7) continue;
            arrayList.add(atomState2);
        }
        return arrayList;
    }

    public void setIgnoreChains(boolean bl) {
        if (bl != this.ignoreChains) {
            this.ignoreChains = bl;
            for (int i = 0; i < this.covNeighbors.length; ++i) {
                this.covNeighbors[i] = null;
            }
            this.allBonds = null;
            this.unbondedAtoms = null;
        }
    }
}

