/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.SecondaryStructure;
import driftwood.r3.NRUBS;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import molikin.GuidePoint;
import molikin.RibbonCrayon;
import molikin.crayons.CompositeCrayon;
import molikin.crayons.ConstCrayon;

public class RibbonPrinter {
    static final DecimalFormat df = Strings.usDecimalFormat("0.###");
    PrintWriter out;
    PrintWriter outGuides;
    RibbonCrayon crayon = ConstCrayon.NONE;
    Triple tmp = new Triple();
    double widthAlpha = 2.0;
    double widthBeta = 2.2;
    double widthCoil = 1.0;
    double widthDefault = 2.0;
    boolean rnaPointIDs = false;
    final int nIntervals = 4;

    public RibbonPrinter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void printGuidepoints(GuidePoint[] guidePointArray) {
        int n;
        Triple triple = new Triple();
        this.out.println("@balllist {guide points} color= red radius= 0.20 master= {guidepts}");
        for (n = 0; n < guidePointArray.length; ++n) {
            this.out.println("{guide point off=" + df.format(guidePointArray[n].offsetFactor) + " wid=" + df.format(guidePointArray[n].widthFactor) + "} " + guidePointArray[n].xyz.format(df));
        }
        this.out.println("@vectorlist {c vectors} color= green master= {guidepts}");
        for (n = 0; n < guidePointArray.length; ++n) {
            triple.likeSum(guidePointArray[n].xyz, guidePointArray[n].cvec);
            this.out.println("{c}P " + guidePointArray[n].xyz.format(df) + " {\"}L " + triple.format(df));
        }
        this.out.println("@vectorlist {d vectors} color= blue master= {guidepts}");
        for (n = 0; n < guidePointArray.length; ++n) {
            triple.likeSum(guidePointArray[n].xyz, guidePointArray[n].dvec);
            this.out.println("{d}P " + guidePointArray[n].xyz.format(df) + " {\"}L " + triple.format(df));
        }
        this.out.flush();
    }

    public void printGuideptGp(GuidePoint[] guidePointArray, String string, String string2, int n, int n2, Tuple3[][] tuple3Array) {
        int n3;
        Triple triple = new Triple();
        this.outGuides.println("@group {" + string + "} off animate dominant");
        this.outGuides.println("@balllist {guide points} color= red radius= 0.20 master= {guidepts} master= {" + string2 + "}");
        this.outGuides.println("{guide point} " + triple.format(df));
        this.outGuides.println("@vectorlist {c vectors} color= green master= {guidepts} master= {" + string2 + "} master= {c vecs} master= {lines}");
        for (n3 = n; n3 <= n2; ++n3) {
            this.outGuides.println("{c}P " + triple.format(df) + " {\"}L " + guidePointArray[n3].cvec.mult(5.0).format(df));
        }
        this.outGuides.println("@balllist {c ends} color= green master= {guidepts} master= {" + string2 + "} master= {c vecs} master = {ends}");
        for (n3 = n; n3 <= n2; ++n3) {
            this.outGuides.println("{" + this.getPointID(tuple3Array[1][n3], guidePointArray[n3], guidePointArray[n3 + 1], n3, 4) + "} " + guidePointArray[n3].cvec.format(df));
        }
        this.outGuides.println("@vectorlist {d vectors} color= blue master= {guidepts} master= {" + string2 + "} master= {d vecs} master= {lines}");
        for (n3 = n; n3 <= n2; ++n3) {
            this.outGuides.println("{d}P " + triple.format(df) + " {\"}L " + guidePointArray[n3].dvec.mult(5.0).format(df));
        }
        this.outGuides.println("@balllist {d ends} color= blue master= {guidepts} master= {" + string2 + "} master= {d vecs} master = {ends}");
        for (n3 = n; n3 <= n2; ++n3) {
            this.outGuides.println("{" + this.getPointID(tuple3Array[1][n3], guidePointArray[n3], guidePointArray[n3 + 1], n3, 4) + "} " + guidePointArray[n3].dvec.format(df));
        }
        this.outGuides.println("@vectorlist {conSeq} color= white alpha= 0.5 master= {guidepts} master= {" + string2 + "} master= {conSeq}");
        this.outGuides.println("{Seq connect} P " + guidePointArray[n].dvec.format(df));
        for (n3 = n + 1; n3 <= n2; ++n3) {
            this.outGuides.println("{Seq connect} " + guidePointArray[n3].dvec.format(df));
        }
        this.outGuides.println("@vectorlist {arrowheads} color= white alpha= 0.5 master= {guidepts} master= {" + string2 + "} master= {conSeq} master= {arrowheads}");
        for (n3 = n + 1; n3 <= n2 && n3 != guidePointArray.length - 2; ++n3) {
            Triple triple2 = new Triple().likeDiff(guidePointArray[n3 - 1].dvec, guidePointArray[n3].dvec).unit().mult(0.3);
            Triple triple3 = new Triple().likeOrthogonal(triple2).mult(0.4);
            Triple triple4 = new Triple().likeDiff(guidePointArray[n3 - 1].dvec, guidePointArray[n3].dvec).unit().mult(0.6).add(guidePointArray[n3].dvec);
            triple2.add(guidePointArray[n3].dvec);
            this.outGuides.println("{arrow} P " + triple2.format(df) + " {\"}L " + new Triple().likeSum(triple4, triple3).format(df));
            this.outGuides.println("{arrow} P " + triple2.format(df) + " {\"}L " + new Triple().likeDiff(triple4, triple3).format(df));
        }
        this.outGuides.println("@vectorlist {conPt} color= yellowtint alpha= 0.5 master= {guidepts} master= {" + string2 + "} master= {conPt}");
        for (n3 = n; n3 <= n2; ++n3) {
            this.outGuides.println("{Pt connect}P " + guidePointArray[n3].dvec.format(df) + " {\"}L " + guidePointArray[n3].cvec.format(df));
        }
    }

    public void printOneLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, 0.0, 99.0);
    }

    public void printTwoLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, -1.0, 2.0);
    }

    public void printThreeLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, -1.0, 1.0);
    }

    public void printFiveLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, -1.0, 0.5);
    }

    public void printNLineImpl(GuidePoint[] guidePointArray, int n, boolean bl, double d, double d2) {
        int n2 = guidePointArray.length;
        NRUBS nRUBS = new NRUBS();
        Tuple3[] tuple3Array = new Triple[n2];
        for (int i = 0; i < n2; ++i) {
            tuple3Array[i] = new Triple();
        }
        for (double d3 = d; d3 <= 1.0; d3 += d2) {
            for (int i = 0; i < n2; ++i) {
                double d4 = guidePointArray[i].offsetFactor > 0.0 ? this.widthAlpha : this.widthBeta;
                double d5 = 0.5 * (this.widthCoil + guidePointArray[i].widthFactor * (d4 - this.widthCoil));
                if (!bl) {
                    d5 = this.widthDefault / 2.0;
                }
                ((Triple)tuple3Array[i]).like(guidePointArray[i].xyz).addMult(d3 * d5, guidePointArray[i].dvec);
            }
            Tuple3[] tuple3Array2 = nRUBS.spline(tuple3Array, n);
            boolean bl2 = true;
            for (int i = 0; i < tuple3Array2.length; ++i) {
                int n3 = i / n + 1;
                this.crayon.forRibbon(tuple3Array2[i], guidePointArray[n3], guidePointArray[n3 + 1], i % n, n);
                if (!this.crayon.shouldPrint()) {
                    bl2 = true;
                    continue;
                }
                String string = this.getPointID(tuple3Array2[i], guidePointArray[n3], guidePointArray[n3 + 1], i % n, n);
                this.tmp.like(tuple3Array2[i]);
                this.out.println("{" + string + "}" + (bl2 ? "P " : "") + this.crayon.getKinString() + " " + this.tmp.format(df));
                bl2 = false;
            }
        }
        this.out.flush();
    }

    public void printFlatRibbon(GuidePoint[] guidePointArray, int n, boolean bl) {
        int n2;
        int n3 = guidePointArray.length;
        NRUBS nRUBS = new NRUBS();
        Tuple3[] tuple3Array = new Triple[n3];
        Tuple3[] tuple3Array2 = new Triple[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            tuple3Array[n2] = new Triple();
            tuple3Array2[n2] = new Triple();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d = guidePointArray[n2].offsetFactor > 0.0 ? this.widthAlpha : this.widthBeta;
            double d2 = 0.5 * (this.widthCoil + guidePointArray[n2].widthFactor * (d - this.widthCoil));
            if (!bl) {
                d2 = this.widthDefault / 2.0;
            }
            ((Triple)tuple3Array[n2]).like(guidePointArray[n2].xyz).addMult(d2, guidePointArray[n2].dvec);
            ((Triple)tuple3Array2[n2]).like(guidePointArray[n2].xyz).addMult(-d2, guidePointArray[n2].dvec);
        }
        Tuple3[] tuple3Array3 = nRUBS.spline(tuple3Array, n);
        Tuple3[] tuple3Array4 = nRUBS.spline(tuple3Array2, n);
        boolean bl2 = true;
        for (int i = 0; i < tuple3Array3.length; ++i) {
            int n4 = i / n + 1;
            this.tmp.likeMidpoint(tuple3Array3[i], tuple3Array4[i]);
            this.crayon.forRibbon(this.tmp, guidePointArray[n4], guidePointArray[n4 + 1], i % n, n);
            if (!this.crayon.shouldPrint()) {
                bl2 = true;
                continue;
            }
            String string = this.getPointID(this.tmp, guidePointArray[n4], guidePointArray[n4 + 1], i % n, n);
            this.tmp.like(tuple3Array3[i]);
            this.out.println("{" + string + "}" + (bl2 ? "X " : "") + this.crayon.getKinString() + " " + this.tmp.format(df));
            this.tmp.like(tuple3Array4[i]);
            this.out.println("{\"}" + this.crayon.getKinString() + " " + this.tmp.format(df));
            bl2 = false;
        }
        this.out.flush();
    }

    public void printFancyRibbon(GuidePoint[] guidePointArray, SecondaryStructure secondaryStructure, double d, double d2, String string, String string2, String string3, ModelState modelState) {
        this.printFancyRibbon(guidePointArray, secondaryStructure, d, d2, string, string2, string3, null, modelState);
    }

    public void printFancyRibbon(GuidePoint[] guidePointArray, SecondaryStructure secondaryStructure, double d, double d2, String string, String string2, String string3, String string4, ModelState modelState) {
        int n;
        Object object;
        Object object2;
        int n2;
        int n3 = guidePointArray.length;
        NRUBS nRUBS = new NRUBS();
        double[] dArray = new double[]{0.0, -d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, -d2, d2};
        Triple[][] tripleArray = new Triple[dArray.length][guidePointArray.length];
        for (int i = 0; i < tripleArray.length; ++i) {
            for (n2 = 0; n2 < tripleArray[i].length; ++n2) {
                tripleArray[i][n2] = new Triple(guidePointArray[n2].xyz).addMult(dArray[i], guidePointArray[n2].dvec);
            }
        }
        Tuple3[][] tuple3ArrayArray = new Tuple3[dArray.length][];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            tuple3ArrayArray[n2] = nRUBS.spline(tripleArray[n2], 4);
        }
        ArrayList<RibbonElement> arrayList = new ArrayList<RibbonElement>();
        RibbonElement ribbonElement3 = new RibbonElement();
        Object object3 = new RibbonElement();
        arrayList.add(ribbonElement3);
        ribbonElement3.type = null;
        for (int i = 0; i < guidePointArray.length - 3; ++i) {
            object2 = guidePointArray[i + 1];
            object = guidePointArray[i + 2];
            Iterator iterator = new RibbonElement(secondaryStructure.getRange(((GuidePoint)object2).nextRes));
            RibbonElement ribbonElement2 = new RibbonElement(secondaryStructure.getRange(((GuidePoint)object).nextRes));
            if (ribbonElement3.type == null) {
                ribbonElement3.like((RibbonElement)((Object)iterator));
            }
            if (!(ribbonElement3.sameSSE((RibbonElement)((Object)iterator)) || ((RibbonElement)((Object)iterator)).type != SecondaryStructure.HELIX && ((RibbonElement)((Object)iterator)).type != SecondaryStructure.STRAND)) {
                ribbonElement3.end = 4 * i + 1;
                ribbonElement3 = new RibbonElement((RibbonElement)((Object)iterator));
                arrayList.add(ribbonElement3);
                ribbonElement3.start = 4 * i + 1;
            }
            if (ribbonElement3.sameSSE(ribbonElement2) || ((RibbonElement)((Object)iterator)).type != SecondaryStructure.HELIX && ((RibbonElement)((Object)iterator)).type != SecondaryStructure.STRAND) continue;
            n = 4 * i + 0;
            if (((RibbonElement)((Object)iterator)).type == SecondaryStructure.STRAND) {
                n += 3;
            }
            ribbonElement3.end = n;
            ribbonElement3 = new RibbonElement();
            arrayList.add(ribbonElement3);
            ribbonElement3.type = SecondaryStructure.COIL;
            ribbonElement3.start = n;
        }
        ribbonElement3.end = tuple3ArrayArray[0].length - 1;
        RibbonCrayon ribbonCrayon = this.getCrayon();
        object2 = new CompositeCrayon().add(new ConstCrayon("")).add(ribbonCrayon);
        Collections.sort(arrayList);
        object = new Vector();
        for (RibbonElement ribbonElement2 : arrayList) {
            if (ribbonElement2.type != SecondaryStructure.STRAND) continue;
            ((Vector)object).add(ribbonElement2);
        }
        for (RibbonElement ribbonElement3 : arrayList) {
            int n4;
            Object object4;
            int n5;
            int n6 = ribbonElement3.start / 4 + 2;
            n = ribbonElement3.end / 4 - 1;
            if (ribbonElement3.type == SecondaryStructure.HELIX) {
                n5 = (int)Math.floor((ribbonElement3.start + ribbonElement3.end) / 2);
                Triple triple = new Triple(tuple3ArrayArray[2][n5]);
                Triple triple2 = new Triple().likeVector(triple, tuple3ArrayArray[1][n5]);
                object4 = new Triple().likeVector(triple, tuple3ArrayArray[1][n5 + 1]);
                Triple triple3 = triple2.cross((Tuple3)object4);
                double d3 = triple3.unit().dot(guidePointArray[(int)Math.floor((double)((double)(n5 / 4))) + 1].cvec.unit());
                this.setCrayon(ribbonCrayon);
                this.out.println("@ribbonlist {fancy helix} " + string);
                for (n4 = ribbonElement3.start; n4 < ribbonElement3.end; ++n4) {
                    if (d3 > 0.0) {
                        this.printFancy(guidePointArray, tuple3ArrayArray[2], n4);
                        this.printFancy(guidePointArray, tuple3ArrayArray[1], n4);
                        continue;
                    }
                    this.printFancy(guidePointArray, tuple3ArrayArray[1], n4);
                    this.printFancy(guidePointArray, tuple3ArrayArray[2], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                this.setCrayon((RibbonCrayon)object2);
                this.out.println("@vectorlist {fancy helix edges} width= 1 " + string + " color= deadblack");
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.start, true);
                for (n4 = ribbonElement3.start; n4 < ribbonElement3.end; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[1], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.start, true);
                for (n4 = ribbonElement3.start; n4 < ribbonElement3.end; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[2], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                continue;
            }
            if (ribbonElement3.type == SecondaryStructure.STRAND) {
                int n7;
                double d4 = 0.0;
                if (ribbonElement3.range.strand != 1) {
                    Triple triple;
                    int n8;
                    int n9;
                    for (n9 = 0; n9 < ((Vector)object).size(); ++n9) {
                        object4 = (RibbonElement)((Vector)object).get(n9);
                        if (!((RibbonElement)object4).range.equals(ribbonElement3.range.previous)) continue;
                        object3 = object4;
                        break;
                    }
                    if ((object4 = ((RibbonElement)object3).range) == null) {
                        object3 = ribbonElement3;
                    }
                    int n10 = ((RibbonElement)object3).start / 4 + 2;
                    int n11 = ((RibbonElement)object3).end / 4 + 1;
                    int n12 = n6;
                    n4 = n10;
                    double d5 = 99999.0;
                    for (n9 = n6; n9 <= n + 2; ++n9) {
                        for (n8 = n10; n8 <= n11; ++n8) {
                            try {
                                AtomState atomState = modelState.get(guidePointArray[n9].prevRes.getAtom(" O  "));
                                triple = modelState.get(guidePointArray[n8].nextRes.getAtom(" N  "));
                                double d6 = atomState.distance(triple);
                                if (!(d6 < d5)) continue;
                                n12 = n9;
                                n4 = n8;
                                d5 = d6;
                                continue;
                            }
                            catch (AtomException atomException) {
                                // empty catch block
                            }
                        }
                    }
                    n8 = Math.min(4 * (n12 - 1), tuple3ArrayArray[4].length);
                    int n13 = Math.min(4 * (n4 - 1), tuple3ArrayArray[4].length);
                    triple = new Triple(tuple3ArrayArray[4][n8]);
                    Triple triple4 = new Triple().likeVector(triple, tuple3ArrayArray[3][n8]);
                    Triple triple5 = new Triple().likeVector(triple, tuple3ArrayArray[3][n8 + 1]);
                    Triple triple6 = triple4.cross(triple5);
                    Triple triple7 = new Triple(tuple3ArrayArray[4][n13]);
                    Triple triple8 = new Triple().likeVector(triple7, tuple3ArrayArray[3][n13]);
                    Triple triple9 = new Triple().likeVector(triple7, tuple3ArrayArray[3][n13 + 1]);
                    Triple triple10 = triple8.cross(triple9);
                    d4 = triple6.dot(triple10);
                }
                this.setCrayon(ribbonCrayon);
                this.out.println("@ribbonlist {fancy sheet} " + string2);
                for (n7 = ribbonElement3.start; n7 < ribbonElement3.end - 1; ++n7) {
                    if (d4 < 0.0 && !((RibbonElement)object3).range.flipped || d4 > 0.0 && ((RibbonElement)object3).range.flipped) {
                        this.printFancy(guidePointArray, tuple3ArrayArray[4], n7);
                        this.printFancy(guidePointArray, tuple3ArrayArray[3], n7);
                        ribbonElement3.range.flipped = true;
                        continue;
                    }
                    this.printFancy(guidePointArray, tuple3ArrayArray[3], n7);
                    this.printFancy(guidePointArray, tuple3ArrayArray[4], n7);
                }
                if (d4 < 0.0 && !((RibbonElement)object3).range.flipped || d4 > 0.0 && ((RibbonElement)object3).range.flipped) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[6], ribbonElement3.end - 2);
                    this.printFancy(guidePointArray, tuple3ArrayArray[5], ribbonElement3.end - 2);
                    this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                } else {
                    this.printFancy(guidePointArray, tuple3ArrayArray[5], ribbonElement3.end - 2);
                    this.printFancy(guidePointArray, tuple3ArrayArray[6], ribbonElement3.end - 2);
                    this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                }
                this.setCrayon((RibbonCrayon)object2);
                this.out.println("@vectorlist {fancy sheet edges} width= 1 " + string2 + " color= deadblack");
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.start, true);
                for (n7 = ribbonElement3.start; n7 < ribbonElement3.end - 1; ++n7) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[3], n7);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[5], ribbonElement3.end - 2);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.start, true);
                for (n7 = ribbonElement3.start; n7 < ribbonElement3.end - 1; ++n7) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[4], n7);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[6], ribbonElement3.end - 2);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement3.end);
                continue;
            }
            if (string4 != null) {
                this.setCrayon(ribbonCrayon);
                this.out.println("@vectorlist {fancy coil edges} " + string4);
                for (n5 = ribbonElement3.start; n5 <= ribbonElement3.end; ++n5) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[0], n5);
                }
            }
            this.setCrayon(ribbonCrayon);
            this.out.println("@vectorlist {fancy coil} " + string3);
            for (n5 = ribbonElement3.start; n5 <= ribbonElement3.end; ++n5) {
                this.printFancy(guidePointArray, tuple3ArrayArray[0], n5);
            }
        }
        this.setCrayon(ribbonCrayon);
        this.out.flush();
    }

    private void printFancy(GuidePoint[] guidePointArray, Tuple3[] tuple3Array, int n) {
        this.printFancy(guidePointArray, tuple3Array, n, false);
    }

    private void printFancy(GuidePoint[] guidePointArray, Tuple3[] tuple3Array, int n, boolean bl) {
        int n2 = (tuple3Array.length - 1) / (guidePointArray.length - 3);
        int n3 = n % n2;
        int n4 = n / n2 + 1;
        this.tmp.like(tuple3Array[n]);
        this.out.print("{");
        this.out.print(this.getPointID(tuple3Array[n], guidePointArray[n4], guidePointArray[n4 + 1], n3, n2));
        this.out.print("}");
        if (bl) {
            this.out.print("P ");
        }
        this.crayon.forRibbon(tuple3Array[n], guidePointArray[n4], guidePointArray[n4 + 1], n3, n2);
        this.out.print(this.crayon.getKinString());
        this.out.print(" ");
        this.out.println(this.tmp.format(df));
    }

    public RibbonCrayon getCrayon() {
        return this.crayon;
    }

    public void setCrayon(RibbonCrayon ribbonCrayon) {
        this.crayon = ribbonCrayon;
    }

    public void setWidth(double d) {
        this.widthDefault = d;
    }

    public void setWidth(double d, double d2, double d3) {
        this.widthAlpha = d;
        this.widthBeta = d2;
        this.widthCoil = d3;
    }

    private String getPointID(Tuple3 tuple3, GuidePoint guidePoint, GuidePoint guidePoint2, int n, int n2) {
        Residue residue = guidePoint.nextRes;
        if (this.rnaPointIDs && n <= n2 / 2) {
            residue = guidePoint.prevRes;
        }
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(residue.getName());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getChain());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getSequenceNumber().trim());
        stringBuffer.append(residue.getInsertionCode());
        return stringBuffer.toString().toLowerCase();
    }

    public void setRnaPointIDs(boolean bl) {
        this.rnaPointIDs = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RibbonElement
    implements Comparable<RibbonElement> {
        int start = 0;
        int end = 0;
        Object type = SecondaryStructure.COIL;
        SecondaryStructure.Range range = null;

        public RibbonElement() {
        }

        public RibbonElement(RibbonElement ribbonElement) {
            this.like(ribbonElement);
        }

        public RibbonElement(SecondaryStructure.Range range) {
            this.range = range;
            this.type = range == null ? SecondaryStructure.COIL : range.getType();
            if (this.type == SecondaryStructure.TURN) {
                this.type = SecondaryStructure.COIL;
            }
        }

        public boolean sameSSE(RibbonElement ribbonElement) {
            return this.type == ribbonElement.type && this.range == ribbonElement.range;
        }

        public void like(RibbonElement ribbonElement) {
            this.start = ribbonElement.start;
            this.end = ribbonElement.end;
            this.type = ribbonElement.type;
            this.range = ribbonElement.range;
        }

        @Override
        public int compareTo(RibbonElement ribbonElement) {
            int n = this.range == null ? 0 : this.range.strand;
            int n2 = ribbonElement.range == null ? 0 : ribbonElement.range.strand;
            return n - n2;
        }
    }
}

