/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.data.CheapSet;
import driftwood.gui.ReflectiveAction;
import driftwood.moldb2.CifReader;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import molikin.AtomClassifier;
import molikin.AtomGraph;
import molikin.BallPrinter;
import molikin.ResClassifier;
import molikin.StickPrinter;
import molikin.Util;
import molikin.gui.MainGuiPane;

public class Test {
    static final DecimalFormat memdf = new DecimalFormat("##0.0E0");
    boolean inputIsCIF = false;
    PrintWriter outWriter = null;
    JDialog frame = null;
    MainGuiPane guiPane = null;
    int kinemageNumber = 1;

    void showGUI(CoordinateFile coordinateFile, PrintWriter printWriter) {
        this.outWriter = printWriter;
        this.guiPane = new MainGuiPane(coordinateFile);
        this.guiPane.right().addCell(new JButton(new ReflectiveAction("Make kinemage", null, this, "onMakeKinemage")));
        this.guiPane.weights(0.0, 0.0).addCell(new JButton(new ReflectiveAction("Done", null, this, "onDone")));
        JFrame jFrame = new JFrame();
        this.frame = new JDialog(jFrame, "Choose residues to display", true);
        this.frame.setContentPane(this.guiPane);
        this.frame.pack();
        this.frame.setVisible(true);
        jFrame.dispose();
    }

    public void onMakeKinemage(ActionEvent actionEvent) {
        this.outWriter.println("@kinemage " + this.kinemageNumber++);
        this.outWriter.println("@onewidth");
        this.guiPane.printKinemage(this.outWriter);
    }

    public void onDone(ActionEvent actionEvent) {
        this.frame.dispose();
    }

    public void Main() throws IOException {
        if (this.inputIsCIF) {
            this.doCIF(new InputStreamReader(System.in), new OutputStreamWriter(System.out));
        } else {
            this.doPDB(new InputStreamReader(System.in), new OutputStreamWriter(System.out));
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        try {
            test.parseArguments(stringArray);
            test.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            test.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    public void doPDB(Reader reader, Writer writer) throws IOException {
        long l = System.currentTimeMillis();
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(reader);
        l = System.currentTimeMillis() - l;
        System.err.println("Loading PDB:            " + l + " ms");
        System.err.println("Mem. usage:             " + memdf.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " bytes");
        PrintWriter printWriter = new PrintWriter(writer);
        this.showGUI(coordinateFile, printWriter);
        printWriter.flush();
        System.err.println("Mem. usage:             " + memdf.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " bytes");
    }

    public void doCIF(Reader reader, Writer writer) throws IOException {
        long l = System.currentTimeMillis();
        CifReader cifReader = new CifReader();
        CoordinateFile coordinateFile = cifReader.read(reader);
        l = System.currentTimeMillis() - l;
        System.err.println("Loading mmCIF:          " + l + " ms");
        System.err.println("Mem. usage:             " + memdf.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " bytes");
        PrintWriter printWriter = new PrintWriter(writer);
        this.showGUI(coordinateFile, printWriter);
        printWriter.flush();
        System.err.println("Mem. usage:             " + memdf.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " bytes");
    }

    public void doModel(CoordinateFile coordinateFile, PrintWriter printWriter) {
        CheapSet cheapSet;
        Model model = coordinateFile.getFirstModel();
        CheapSet cheapSet2 = cheapSet = new CheapSet(model.getResidues());
        long l = System.currentTimeMillis();
        ResClassifier resClassifier = new ResClassifier(model.getResidues());
        l = System.currentTimeMillis() - l;
        System.err.println("Classifying residues:   " + l + " ms");
        l = System.currentTimeMillis();
        Collection collection = Util.extractOrderedStatesByName(model);
        AtomClassifier atomClassifier = new AtomClassifier(collection, resClassifier);
        l = System.currentTimeMillis() - l;
        System.err.println("Classifying atoms:      " + l + " ms");
        l = System.currentTimeMillis();
        AtomGraph atomGraph = new AtomGraph(collection);
        l = System.currentTimeMillis() - l;
        System.err.println("Spatial binning:        " + l + " ms");
        l = System.currentTimeMillis();
        Collection collection2 = atomGraph.getBonds();
        l = System.currentTimeMillis() - l;
        System.err.println("Building bond network:  " + l + " ms");
        l = System.currentTimeMillis();
        StickPrinter stickPrinter = new StickPrinter(printWriter);
        BallPrinter ballPrinter = new BallPrinter(printWriter);
        printWriter.println("@kinemage");
        printWriter.println("@onewidth");
        printWriter.println("@group {macromol}");
        printWriter.println("@subgroup {mainchain}");
        printWriter.println("@vectorlist {heavy} color= white");
        stickPrinter.printSticks(collection2, atomClassifier.mcHeavy, atomClassifier.mcHeavy);
        printWriter.println("@vectorlist {H} color= gray master= {H}");
        stickPrinter.printSticks(collection2, atomClassifier.mcHydro, atomClassifier.mcHeavy);
        printWriter.println("@subgroup {sidechains}");
        printWriter.println("@vectorlist {heavy} color= cyan");
        stickPrinter.printSticks(collection2, atomClassifier.scHeavy, atomClassifier.bioHeavy, cheapSet2, cheapSet, model.toString());
        printWriter.println("@vectorlist {H} color= gray master= {H}");
        stickPrinter.printSticks(collection2, atomClassifier.scHydro, atomClassifier.bioHeavy, cheapSet2, cheapSet, model.toString());
        if (atomClassifier.hetHeavy.size() > 0) {
            printWriter.println("@subgroup {hets}");
            printWriter.println("@vectorlist {heavy} color= pink");
            stickPrinter.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.hetHeavy);
            printWriter.println("@vectorlist {H} color= gray master= {H}");
            stickPrinter.printSticks(collection2, atomClassifier.hetHydro, atomClassifier.hetHeavy);
            printWriter.println("@vectorlist {connect} color= pinktint");
            stickPrinter.printSticks(collection2, atomClassifier.hetHeavy, atomClassifier.bioHeavy);
        }
        if (atomClassifier.metal.size() > 0) {
            printWriter.println("@subgroup {metals}");
            printWriter.println("@spherelist {heavy} color= magenta radius= 0.5");
            ballPrinter.printBalls(atomClassifier.metal);
        }
        if (atomClassifier.watHeavy.size() > 0) {
            printWriter.println("@subgroup {water}");
            printWriter.println("@balllist {heavy} color= bluetint radius= 0.15");
            ballPrinter.printBalls(atomClassifier.watHeavy);
            printWriter.println("@vectorlist {H} color= gray master= {H}");
            stickPrinter.printSticks(collection2, atomClassifier.watHydro, atomClassifier.watHeavy);
        }
        l = System.currentTimeMillis() - l;
        System.err.println("Drawing bonds:          " + l + " ms");
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Test.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'Test.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("molikin.Test");
        System.err.println("Copyright (C) 2005 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-cif") || string.equals("mmcif")) {
            this.inputIsCIF = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

