/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.data.CheapSet;
import driftwood.data.FinalArrayList;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import molikin.Bond;
import molikin.ResClassifier;

public class VirtualBackbone {
    Model model;
    ModelState[] states;
    ResClassifier resC;
    Map atomIndices;
    int nextAtomIndex = 0;
    Collection protBonds = null;
    Collection nucBonds = null;

    public VirtualBackbone(Model model, Collection collection, ResClassifier resClassifier) {
        this.model = model;
        this.states = collection.toArray(new ModelState[collection.size()]);
        this.resC = resClassifier;
        this.atomIndices = new IdentityHashMap();
    }

    public Collection getProteinBonds() {
        if (this.protBonds == null) {
            this.protBonds = new CheapSet();
            Atom atom = null;
            for (Residue residue : this.model.getResidues()) {
                if (this.resC.classify(residue) != ResClassifier.PROTEIN) {
                    atom = null;
                    continue;
                }
                Atom atom2 = residue.getAtom(" CA ");
                if (atom2 != null && atom != null && atom2.getResidue().getChain().equals(atom.getResidue().getChain())) {
                    this.bondAllStates(atom, atom2, 5.0, this.protBonds);
                }
                atom = atom2;
            }
            Object[] objectArray = this.protBonds.toArray();
            this.protBonds = null;
            Arrays.sort(objectArray);
            this.protBonds = new FinalArrayList(objectArray);
        }
        return this.protBonds;
    }

    public Collection getNucAcidBonds() {
        if (this.nucBonds == null) {
            this.nucBonds = new CheapSet();
            Atom atom = null;
            for (Residue residue : this.model.getResidues()) {
                Atom atom2;
                if (this.resC.classify(residue) != ResClassifier.NUCACID) {
                    atom = null;
                    continue;
                }
                Atom atom3 = residue.getAtom(" P  ");
                Atom atom4 = residue.getAtom(" C1*");
                if (atom4 == null) {
                    atom4 = residue.getAtom(" C1'");
                }
                if ((atom2 = residue.getAtom(" C4*")) == null) {
                    atom2 = residue.getAtom(" C4'");
                }
                if (atom3 != null && atom != null && atom3.getResidue().getChain().equals(atom.getResidue().getChain())) {
                    this.bondAllStates(atom, atom3, 5.0, this.nucBonds);
                }
                if (atom3 != null && atom2 != null) {
                    this.bondAllStates(atom3, atom2, 5.0, this.nucBonds);
                }
                if (atom2 != null && atom4 != null) {
                    this.bondAllStates(atom2, atom4, 5.0, this.nucBonds);
                }
                atom = atom2;
            }
            Object[] objectArray = this.nucBonds.toArray();
            this.nucBonds = null;
            Arrays.sort(objectArray);
            this.nucBonds = new FinalArrayList(objectArray);
        }
        return this.nucBonds;
    }

    private void bondAllStates(Atom atom, Atom atom2, double d, Collection collection) {
        double d2 = d * d;
        for (int i = 0; i < this.states.length; ++i) {
            try {
                AtomState atomState = this.states[i].get(atom);
                AtomState atomState2 = this.states[i].get(atom2);
                if (!(atomState.sqDistance(atomState2) <= d2)) continue;
                collection.add(new Bond(atomState, this.getIndex(atomState), atomState2, this.getIndex(atomState2)));
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    private int getIndex(AtomState atomState) {
        Integer n = (Integer)this.atomIndices.get(atomState);
        if (n == null) {
            n = new Integer(this.nextAtomIndex++);
            this.atomIndices.put(atomState, n);
        }
        return n;
    }
}

