/*
 * Decompiled with CFR 0.152.
 */
package molikin.crayons;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Residue;
import driftwood.r3.Tuple3;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import molikin.AtomCrayon;
import molikin.BondCrayon;
import molikin.GuidePoint;
import molikin.RibbonCrayon;
import molikin.crayons.AbstractCrayon;

public class ResColorMapCrayon
extends AbstractCrayon
implements AtomCrayon,
BondCrayon,
RibbonCrayon {
    static final String[] RAINBOW = new String[]{"blue", "sky", "cyan", "sea", "green", "lime", "yellow", "gold", "orange", "red"};
    Map map;
    String color = null;

    protected ResColorMapCrayon(Map map) {
        this.map = map;
    }

    public void forAtom(AtomState atomState) {
        this.setColor(atomState.getResidue());
    }

    public void forBond(AtomState atomState, AtomState atomState2) {
        this.setColor(atomState.getResidue());
    }

    public void forRibbon(Tuple3 tuple3, GuidePoint guidePoint, GuidePoint guidePoint2, int n, int n2) {
        this.setColor(guidePoint.nextRes);
    }

    private void setColor(Residue residue) {
        this.color = (String)this.map.get(residue);
    }

    public String getColor() {
        return this.color;
    }

    public String getKinString() {
        return this.color == null ? "" : this.color;
    }

    public static ResColorMapCrayon newRainbow(Collection collection) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            n += ((Collection)iterator.next()).size();
        }
        int n2 = 0;
        HashMap<Residue, String> hashMap = new HashMap<Residue, String>();
        for (Collection collection2 : collection) {
            for (Residue residue : collection2) {
                int n3 = RAINBOW.length * n2 / n;
                hashMap.put(residue, RAINBOW[n3]);
                ++n2;
            }
        }
        return new ResColorMapCrayon(hashMap);
    }
}

