/*
 * Decompiled with CFR 0.152.
 */
package molikin.crayons;

import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Residue;
import driftwood.r3.Tuple3;
import java.util.HashMap;
import java.util.Map;
import molikin.AtomCrayon;
import molikin.BondCrayon;
import molikin.GuidePoint;
import molikin.RibbonCrayon;
import molikin.crayons.AbstractCrayon;

public class RotaramaCrayon
extends AbstractCrayon
implements AtomCrayon,
BondCrayon,
RibbonCrayon {
    private static final String[] R_COLORS = new String[]{"white", "yellowtint", "gold", "orange", "red", "hotpink", "magenta", "purple", "blue"};
    private static final double[] R_MAXVALS = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.1, 0.25};
    int colorIndex;
    double[] maxvals;
    String[] colors;
    HashMap<Residue, Double> rota;
    HashMap<Residue, Double> rama;

    public RotaramaCrayon() {
        this(R_MAXVALS, R_COLORS, null, null);
    }

    protected RotaramaCrayon(double[] dArray, String[] stringArray) {
        this(dArray, stringArray, null, null);
    }

    public RotaramaCrayon(Map map, Map map2) {
        this(R_MAXVALS, R_COLORS, map, map2);
    }

    protected RotaramaCrayon(double[] dArray, String[] stringArray, Map map, Map map2) {
        if (dArray.length + 1 > stringArray.length) {
            throw new IllegalArgumentException("Must have at least one more color than value-stop");
        }
        this.maxvals = (double[])dArray.clone();
        this.colors = (String[])stringArray.clone();
        this.rota = (HashMap)map;
        this.rama = (HashMap)map2;
    }

    public void forAtom(AtomState atomState) {
        this.setValue(this.scoreForAtom(atomState));
    }

    public void forBond(AtomState atomState, AtomState atomState2) {
        this.setValue(this.scoreForAtom(atomState));
    }

    public void forRibbon(Tuple3 tuple3, GuidePoint guidePoint, GuidePoint guidePoint2, int n, int n2) {
        this.setValue(0.0);
    }

    private double scoreForAtom(AtomState atomState) {
        if (this.rama == null || this.rota == null) {
            throw new UnsupportedOperationException();
        }
        Atom atom = atomState.getAtom();
        if (atom != null) {
            Residue residue = atom.getResidue();
            if (residue != null) {
                if (AminoAcid.isBackbone(atom)) {
                    if (this.rama.get(residue) != null) {
                        return this.rama.get(residue);
                    }
                    return Double.POSITIVE_INFINITY;
                }
                if (this.rota.get(residue) != null) {
                    return this.rota.get(residue);
                }
                return Double.POSITIVE_INFINITY;
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    protected void setValue(double d) {
        this.colorIndex = 0;
        while (this.colorIndex < this.maxvals.length && !(this.maxvals[this.colorIndex] > d)) {
            ++this.colorIndex;
        }
    }

    public String getColor() {
        return this.colors[this.colorIndex];
    }

    public String getKinString() {
        return this.getColor();
    }
}

