/*
 * Decompiled with CFR 0.152.
 */
package molikin.gui;

import driftwood.gui.TablePane2;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import molikin.gui.DrawingPane;
import molikin.gui.SelectorPane;
import molikin.logic.VanDerWaalsLogic;

public class VanDerWaalsPane
extends TablePane2
implements DrawingPane {
    CoordinateFile coordFile;
    String title;
    SelectorPane selector;
    JCheckBox cbProtein;
    JCheckBox cbNucleic;
    JCheckBox cbHets;
    JCheckBox cbMetals;
    JCheckBox cbWater;
    JCheckBox cbMainchain;
    JCheckBox cbSidechains;
    JCheckBox cbHydrogens;
    JCheckBox cbUseSpheres;
    JComboBox cmColorBy;

    public VanDerWaalsPane(CoordinateFile coordinateFile, String string) {
        this.coordFile = coordinateFile;
        this.title = string;
        this.buildGUI();
    }

    private void buildGUI() {
        this.selector = new SelectorPane(this.coordFile);
        this.cbProtein = new JCheckBox("protein", true);
        this.cbNucleic = new JCheckBox("nucleic acids", true);
        this.cbHets = new JCheckBox("hets (non-water)", true);
        this.cbMetals = new JCheckBox("metals/ions", true);
        this.cbWater = new JCheckBox("water", false);
        this.cbMainchain = new JCheckBox("mainchain", true);
        this.cbSidechains = new JCheckBox("sidechains", true);
        this.cbHydrogens = new JCheckBox("hydrogens", true);
        this.cbUseSpheres = new JCheckBox("use spheres?", false);
        this.cmColorBy = new JComboBox<Object>(new Object[]{VanDerWaalsLogic.COLOR_BY_ELEMENT, VanDerWaalsLogic.COLOR_BY_RES_TYPE, VanDerWaalsLogic.COLOR_BY_B_FACTOR, VanDerWaalsLogic.COLOR_BY_OCCUPANCY});
        this.hfill(true).vfill(true).addCell(this.selector, 2, 1).newRow();
        this.weights(1.0, 0.0).memorize();
        this.addCell(VanDerWaalsPane.strut(0, 6)).newRow();
        this.startSubtable(2, 1);
        this.weights(0.0, 0.0).memorize();
        this.addCell(new JLabel("Color by")).addCell(this.cmColorBy);
        this.endSubtable();
        this.addCell(VanDerWaalsPane.strut(0, 6)).newRow();
        this.addCell(this.cbProtein).addCell(this.cbMainchain).newRow();
        this.addCell(this.cbNucleic).addCell(this.cbSidechains).newRow();
        this.addCell(this.cbHets).addCell(this.cbHydrogens).newRow();
        this.addCell(this.cbMetals).skip().newRow();
        this.addCell(this.cbWater).addCell(this.cbUseSpheres).newRow();
        this.setBorder(BorderFactory.createTitledBorder(null, "van der Waals"));
    }

    public String toString() {
        return this.title;
    }

    public Collection getSelectedModels() {
        return this.selector.getSelectedModels();
    }

    public Collection getSelectedChains() {
        return this.selector.getSelectedChains();
    }

    public void printKinemage(PrintWriter printWriter, Model model, String string, String string2, String string3) {
        Collection collection = this.selector.getSelectedModels();
        if (!collection.contains(model)) {
            return;
        }
        Collection collection2 = this.selector.getSelectedChains();
        if (!collection2.contains(string)) {
            return;
        }
        Set set = model.getChain(string);
        if (set == null) {
            return;
        }
        Set set2 = this.selector.getSelectedResidues(set);
        if (set2.size() == 0) {
            return;
        }
        VanDerWaalsLogic vanDerWaalsLogic = new VanDerWaalsLogic();
        vanDerWaalsLogic.doProtein = this.cbProtein.isSelected();
        vanDerWaalsLogic.doNucleic = this.cbNucleic.isSelected();
        vanDerWaalsLogic.doHets = this.cbHets.isSelected();
        vanDerWaalsLogic.doMetals = this.cbMetals.isSelected();
        vanDerWaalsLogic.doWater = this.cbWater.isSelected();
        vanDerWaalsLogic.doMainchain = this.cbMainchain.isSelected();
        vanDerWaalsLogic.doSidechains = this.cbSidechains.isSelected();
        vanDerWaalsLogic.doHydrogens = this.cbHydrogens.isSelected();
        vanDerWaalsLogic.doUseSpheres = this.cbUseSpheres.isSelected();
        vanDerWaalsLogic.colorBy = this.cmColorBy.getSelectedItem();
        vanDerWaalsLogic.printKinemage(printWriter, model, set2, string2, string3);
    }
}

