/*
 * Decompiled with CFR 0.152.
 */
package molikin.logic;

import driftwood.data.CheapSet;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.util.Strings;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import molikin.AtomClassifier;
import molikin.BallPrinter;
import molikin.DataCache;
import molikin.ResClassifier;
import molikin.Util;
import molikin.crayons.AltConfCrayon;
import molikin.crayons.BfactorCrayon;
import molikin.crayons.CompositeCrayon;
import molikin.crayons.OccupancyCrayon;
import molikin.crayons.ResTypeCrayon;
import molikin.logic.Logic;

public class VanDerWaalsLogic
implements Logic {
    static final DecimalFormat df2 = Strings.usDecimalFormat("0.0#");
    public static final Object COLOR_BY_ELEMENT = "element";
    public static final Object COLOR_BY_RES_TYPE = "residue type";
    public static final Object COLOR_BY_B_FACTOR = "B factor";
    public static final Object COLOR_BY_OCCUPANCY = "occupancy";
    PrintWriter out = null;
    BallPrinter bp = null;
    public boolean doProtein;
    public boolean doNucleic;
    public boolean doHets;
    public boolean doMetals;
    public boolean doWater;
    public boolean doMainchain;
    public boolean doSidechains;
    public boolean doHydrogens;
    public boolean doUseSpheres;
    public Object colorBy = COLOR_BY_ELEMENT;

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string, String string2) {
        this.out = printWriter;
        this.bp = new BallPrinter(printWriter);
        this.bp.setCrayon(new AltConfCrayon());
        if (this.colorBy == COLOR_BY_ELEMENT) {
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_RES_TYPE) {
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new ResTypeCrayon()));
        } else if (this.colorBy == COLOR_BY_B_FACTOR) {
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new BfactorCrayon()));
        } else if (this.colorBy == COLOR_BY_OCCUPANCY) {
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new OccupancyCrayon()));
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.doProtein) {
            this.printProtein(model, set, string2);
        }
        if (this.doNucleic) {
            this.printNucAcid(model, set, string2);
        }
        if (this.doHets) {
            this.printHets(model, set);
        }
        if (this.doMetals) {
            this.printMetals(model, set);
        }
        if (this.doWater) {
            this.printWaters(model, set);
        }
        this.out.flush();
        this.out = null;
        this.bp = null;
    }

    void printProtein(Model model, Set set, String string) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.proteinRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection = dataCache.getCovalentGraph().getBonds();
        if (this.doMainchain && atomClassifier.mcHeavy.size() > 0) {
            this.printAtomBalls(atomClassifier.mcHeavy, cheapSet, "master= {protein} master= {mainchain}");
            if (this.doHydrogens && atomClassifier.mcHydro.size() > 0) {
                this.printAtomBalls(atomClassifier.mcHydro, cheapSet, "master= {protein} master= {mainchain}");
            }
        }
        if (this.doSidechains && atomClassifier.scHeavy.size() > 0) {
            this.printAtomBalls(atomClassifier.scHeavy, cheapSet, "master= {protein} master= {sidechains}");
            if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                this.printAtomBalls(atomClassifier.scHydro, cheapSet, "master= {protein} master= {sidechains}");
            }
        }
    }

    void printNucAcid(Model model, Set set, String string) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.nucAcidRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection = dataCache.getCovalentGraph().getBonds();
        if (this.doMainchain && atomClassifier.mcHeavy.size() > 0) {
            this.printAtomBalls(atomClassifier.mcHeavy, cheapSet, "master= {nucleic acid} master= {mainchain}");
            if (this.doHydrogens && atomClassifier.mcHydro.size() > 0) {
                this.printAtomBalls(atomClassifier.mcHydro, cheapSet, "master= {nucleic acid} master= {mainchain}");
            }
        }
        if (this.doSidechains && atomClassifier.scHeavy.size() > 0) {
            this.printAtomBalls(atomClassifier.scHeavy, cheapSet, "master= {nucleic acid} master= {sidechains}");
            if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                this.printAtomBalls(atomClassifier.scHydro, cheapSet, "master= {nucleic acid} master= {sidechains}");
            }
        }
    }

    void printHets(Model model, Set set) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(resClassifier.ohetRes);
        cheapSet.addAll(resClassifier.unknownRes);
        cheapSet.retainAll(set);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection = dataCache.getCovalentGraph().getBonds();
        if (atomClassifier.hetHeavy.size() > 0) {
            this.printAtomBalls(atomClassifier.hetHeavy, cheapSet, "master= {hets}");
        }
        if (this.doHydrogens && atomClassifier.hetHydro.size() > 0) {
            this.printAtomBalls(atomClassifier.hetHydro, cheapSet, "master= {hets}");
        }
    }

    void printMetals(Model model, Set set) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.metalRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        if (atomClassifier.metal.size() == 0) {
            return;
        }
        this.printAtomBalls(atomClassifier.metal, cheapSet, "master= {metals}");
    }

    void printWaters(Model model, Set set) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.waterRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        if (atomClassifier.watHeavy.size() > 0) {
            this.printAtomBalls(atomClassifier.watHeavy, cheapSet, "master= {waters}");
        }
        if (this.doHydrogens && atomClassifier.watHydro.size() > 0) {
            this.printAtomBalls(atomClassifier.watHydro, cheapSet, "master= {waters}");
        }
    }

    void printAtomBalls(Collection collection, Set set, String string) {
        Collection<Object> collection2;
        Object object;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        for (Object object2 : collection) {
            if (!set.contains(((AtomState)object2).getResidue())) continue;
            object = ((AtomState)object2).getElement();
            collection2 = (Collection)hashMap.get(object);
            if (collection2 == null) {
                collection2 = new ArrayList<Object>();
                hashMap.put(object, (ArrayList<Object>)collection2);
            }
            collection2.add(object2);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (Collection)hashMap.get(object2);
            collection2 = Util.getElementColor((String)object2);
            double d = Util.getVdwRadius((String)object2);
            if (this.doUseSpheres) {
                this.out.print("@spherelist");
            } else {
                this.out.print("@balllist");
            }
            this.out.println(" {" + (String)object2 + " vdW} color= " + collection2 + " radius= " + df2.format(d) + " master= {" + (String)object2 + "} master= {vdW} " + string);
            this.bp.printBalls((Collection)object);
        }
    }
}

