/*
 * Decompiled with CFR 0.152.
 */
package dangle;

import dangle.AtomSpec;
import dangle.ResSpec;
import dangle.XyzSpec;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class Measurement {
    public static final Object TYPE_UNKNOWN = "unknown";
    public static final Object TYPE_DISTANCE = "distance";
    public static final Object TYPE_ANGLE = "angle";
    public static final Object TYPE_DIHEDRAL = "dihedral";
    public static final Object TYPE_V_ANGLE = "vector_angle";
    public static final Object TYPE_MAXB = "maxb";
    public static final Object TYPE_MINQ = "minq";
    public static final Object TYPE_PLANARITY = "planarity";
    public static final Object TYPE_PUCKER = "pucker";
    public static final Object TYPE_BASEPPERP = "basePperp";
    public static final Object TYPE_ISPREPRO = "isprepro";
    ResSpec resSpec = null;
    String label;
    double mean = Double.NaN;
    double sigma = Double.NaN;
    double deviation = Double.NaN;

    public Measurement(String string) {
        this.label = string;
    }

    public double measure(Model model, ModelState modelState, Residue residue, boolean bl) {
        if (!(Measurement.isProtOrNucAcid(residue) || Measurement.isHet(residue) && bl)) {
            this.deviation = Double.NaN;
            return Double.NaN;
        }
        double d = this.resSpec == null || this.resSpec.isMatch(model, modelState, residue) ? this.measureImpl(model, modelState, residue) : Double.NaN;
        this.deviation = (d - this.mean) / this.sigma;
        return d;
    }

    public double measure(Model model, ModelState modelState, Residue residue) {
        return this.measure(model, modelState, residue, false);
    }

    public double getDeviation() {
        return this.deviation;
    }

    protected abstract double measureImpl(Model var1, ModelState var2, Residue var3);

    public String getLabel() {
        return this.label;
    }

    public Object getType() {
        return TYPE_UNKNOWN;
    }

    public void setResSpec(ResSpec resSpec) {
        if (this.resSpec == null) {
            this.resSpec = resSpec;
        } else {
            ResSpec resSpec2 = new ResSpec(resSpec.resOffset, this.resSpec.requireCis || resSpec.requireCis, this.resSpec.requireDeoxy || resSpec.requireDeoxy, this.resSpec.requireOxy || resSpec.requireOxy, this.resSpec.require2p || resSpec.require2p, this.resSpec.requireDisulf || resSpec.requireDisulf, resSpec.origResName);
            if (resSpec2.requireDeoxy && resSpec2.requireOxy) {
                throw new IllegalArgumentException("Cannot combine oxy and deoxy residue specifiers!");
            }
            this.resSpec = resSpec2;
        }
    }

    public static boolean isProtOrNucAcid(Residue residue) {
        String string = ":GLY:ALA:VAL:PHE:PRO:MET:ILE:LEU:ASP:GLU:LYS:ARG:SER:THR:TYR:HIS:CYS:ASN:GLN:TRP:ASX:GLX:ACE:FOR:NH2:NME:MSE:AIB:ABU:PCA:MLY:CYO:M3L:DGN:CSD:";
        String string2 = ":  C:  G:  A:  T:  U:CYT:GUA:ADE:THY:URA:URI:GSP:H2U:PSU:4SU:1MG:2MG:M2G:5MC:5MU:T6A:1MA:RIA:OMC:OMG: YG:  I:7MG:YYG:YG :A2M:5FU:G7M:OMU:PR5:FHU:XUG:A23:UMS:FMU:UR3:CFL:UD5:CSL:UFT:5IC:5BU:BGM:CBR:U34:CCC:AVC:TM2:AET: IU:C  :G  :A  :T  :U  :I  : rC: rG: rA: rT: rU: dC: dG: dA: dT: dU: DC: DG: DA: DT: DU:";
        String string3 = "CTP:CDP:CMP:GTP:GDP:GMP:ATP:ADP:AMP:TTP:TDP:TMP:UTP:UDP:UMP";
        String string4 = residue.getName();
        return string.indexOf(string4) != -1 || string2.indexOf(string4) != -1;
    }

    public static boolean isHet(Residue residue) {
        for (Atom atom : residue.getAtoms()) {
            if (!atom.isHet()) continue;
            return true;
        }
        return false;
    }

    public Measurement reqCis() {
        if (this.resSpec == null) {
            this.resSpec = new ResSpec();
        }
        this.resSpec.requireCis();
        return this;
    }

    public Measurement reqDeoxy() {
        if (this.resSpec == null) {
            this.resSpec = new ResSpec();
        }
        this.resSpec.requireDeoxy();
        return this;
    }

    public Measurement reqOxy() {
        if (this.resSpec == null) {
            this.resSpec = new ResSpec();
        }
        this.resSpec.requireOxy();
        return this;
    }

    public Measurement req2p() {
        if (this.resSpec == null) {
            this.resSpec = new ResSpec();
        }
        this.resSpec.require2p();
        return this;
    }

    public Measurement reqDisulf() {
        if (this.resSpec == null) {
            this.resSpec = new ResSpec();
        }
        this.resSpec.requireDisulf();
        return this;
    }

    public Measurement reqResName(String string) {
        if (this.resSpec == null) {
            this.resSpec = new ResSpec(string);
        } else {
            this.resSpec.setResNames(string);
        }
        return this;
    }

    public Measurement setMeanAndSigma(double d, double d2) {
        this.mean = d;
        this.sigma = d2;
        return this;
    }

    public String toString() {
        return (this.resSpec == null ? "" : this.resSpec + " ") + this.toStringImpl() + (!Double.isNaN(this.mean) && !Double.isNaN(this.sigma) ? " ideal " + this.mean + " " + this.sigma : "");
    }

    protected abstract String toStringImpl();

    public static Measurement[] newSuperBuiltin(String string) {
        if ("rnabb".equals(string)) {
            return new Measurement[]{Measurement.newBuiltin("alpha").reqOxy(), Measurement.newBuiltin("beta").reqOxy(), Measurement.newBuiltin("gamma").reqOxy(), Measurement.newBuiltin("delta").reqOxy(), Measurement.newBuiltin("epsilon").reqOxy(), Measurement.newBuiltin("zeta").reqOxy()};
        }
        if ("dnabb".equals(string)) {
            return new Measurement[]{Measurement.newBuiltin("alpha").reqDeoxy(), Measurement.newBuiltin("beta").reqDeoxy(), Measurement.newBuiltin("gamma").reqDeoxy(), Measurement.newBuiltin("delta").reqDeoxy(), Measurement.newBuiltin("epsilon").reqDeoxy(), Measurement.newBuiltin("zeta").reqDeoxy()};
        }
        if ("suitefit".equals(string)) {
            return new Measurement[]{Measurement.newBuiltin("O5'-C5'"), Measurement.newBuiltin("C5'-C4'"), Measurement.newBuiltin("C4'-C3'"), Measurement.newBuiltin("C3'-C2'"), Measurement.newBuiltin("C2'-C1'"), Measurement.newBuiltin("O4'-C1'"), Measurement.newBuiltin("O4'-C4'"), Measurement.newBuiltin("O3'-C3'"), Measurement.newBuiltin("C2'-O2'"), Measurement.newBuiltin("C3'-C4'-O4'"), Measurement.newBuiltin("C4'-O4'-C1'"), Measurement.newBuiltin("O4'-C1'-C2'"), Measurement.newBuiltin("C1'-C2'-C3'"), Measurement.newBuiltin("C4'-C3'-C2'"), Measurement.newBuiltin("C3'-C2'-C1'"), Measurement.newBuiltin("C2'-C1'-O4'"), Measurement.newBuiltin("C1'-O4'-C4'"), Measurement.newBuiltin("O3'-C3'-C4'"), Measurement.newBuiltin("C3'-C4'-C5'"), Measurement.newBuiltin("delta"), Measurement.newBuiltin("C3'-C4'-O4'-C1'"), Measurement.newBuiltin("C4'-O4'-C1'-C2'"), Measurement.newBuiltin("O4'-C1'-C2'-C3'"), Measurement.newBuiltin("C4'-C3'-C2'-C1'"), Measurement.newBuiltin("C3'-C2'-C1'-O4'"), Measurement.newBuiltin("C2'-C1'-O4'-C4'"), Measurement.newBuiltin("O3'-C4'-C3'-C2'"), Measurement.newBuiltin("C5'-C3'-C4'-O4'")};
        }
        if ("disulfides".equals(string) || "disulf".equals(string) || "ss".equals(string)) {
            return new Measurement[]{Measurement.newBuiltin("phi").reqDisulf(), Measurement.newBuiltin("psi").reqDisulf(), Measurement.newBuiltin("chi1").reqDisulf(), Measurement.newBuiltin("chi2").reqDisulf(), Measurement.newBuiltin("chi3").reqDisulf(), Measurement.newBuiltin("chi2'"), Measurement.newBuiltin("chi1'"), Measurement.newBuiltin("phi'"), Measurement.newBuiltin("psi'")};
        }
        return null;
    }

    public static Measurement newBuiltin(String string) {
        if ("phi".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_C__"), new AtomSpec(0, "_N__"), new AtomSpec(0, "_CA_"), new AtomSpec(0, "_C__"));
        }
        if ("psi".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_N__"), new AtomSpec(0, "_CA_"), new AtomSpec(0, "_C__"), new AtomSpec(1, "_N__"));
        }
        if ("omega".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_CA_"), new AtomSpec(-1, "_C__"), new AtomSpec(0, "_N__"), new AtomSpec(0, "_CA_"));
        }
        if ("chi1".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_N__"), new AtomSpec(0, "_CA_"), new AtomSpec(0, "_CB_"), new AtomSpec(0, "/_[ACNOS]G[_1]/"));
        }
        if ("chi2".equals(string)) {
            return new Group(new Dihedral(string, new AtomSpec(0, "_CA_"), new AtomSpec(0, "_CB_"), new AtomSpec(0, "_SG_"), new AtomSpec(0, "_SG_").otherEndDisulf())).add(new Dihedral(string, new AtomSpec(0, "_CA_"), new AtomSpec(0, "_CB_"), new AtomSpec(0, "/_[ACNOS]G[_1]/"), new AtomSpec(0, "/_[ACNOS]D[_1]/")));
        }
        if ("chi3".equals(string)) {
            return new Group(new Dihedral(string, new AtomSpec(0, "_CB_"), new AtomSpec(0, "_SG_"), new AtomSpec(0, "_SG_").otherEndDisulf(), new AtomSpec(0, "_CB_").otherEndDisulf())).add(new Dihedral(string, new AtomSpec(0, "_CB_"), new AtomSpec(0, "_CG_"), new AtomSpec(0, "_CD_"), new AtomSpec(0, "_N__")).reqResName("PRO")).add(new Dihedral(string, new AtomSpec(0, "_CB_"), new AtomSpec(0, "/_[ACNOS]G[_1]/"), new AtomSpec(0, "/(_[ACNOS]D[_1])|(SE__)/"), new AtomSpec(0, "/_[ACNOS]E[_1]/")));
        }
        if ("chi4".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "/_[ACNOS]G[_1]/"), new AtomSpec(0, "/_[ACNOS]D[_1]/"), new AtomSpec(0, "/_[ACNOS]E[_1]/"), new AtomSpec(0, "/_[ACNOS]Z[_1]/"));
        }
        if ("phi'".equals(string) || "phip".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_C__").otherEndDisulf(), new AtomSpec(0, "_N__").otherEndDisulf(), new AtomSpec(0, "_CA_").otherEndDisulf(), new AtomSpec(0, "_C__").otherEndDisulf()).reqDisulf();
        }
        if ("psi'".equals(string) || "psip".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_N__").otherEndDisulf(), new AtomSpec(0, "_CA_").otherEndDisulf(), new AtomSpec(0, "_C__").otherEndDisulf(), new AtomSpec(1, "_N__").otherEndDisulf()).reqDisulf();
        }
        if ("chi1'".equals(string) || "chi1p".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_N__").otherEndDisulf(), new AtomSpec(0, "_CA_").otherEndDisulf(), new AtomSpec(0, "_CB_").otherEndDisulf(), new AtomSpec(0, "_SG_").otherEndDisulf()).reqDisulf();
        }
        if ("chi2'".equals(string) || "chi2p".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_CA_").otherEndDisulf(), new AtomSpec(0, "_CB_").otherEndDisulf(), new AtomSpec(0, "_SG_").otherEndDisulf(), new AtomSpec(0, "_SG_")).reqDisulf();
        }
        if ("tau".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_N__"), new AtomSpec(0, "_CA_"), new AtomSpec(0, "_C__"));
        }
        if ("cbdev".equals(string)) {
            return new Group(new Distance(string, new AtomSpec(0, "_CB_"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_N__"), new AtomSpec(0, "_C__"), new AtomSpec(0, "_CA_"), 1.536, 110.1, 110.6, 122.9, -122.6)).reqResName("ALA")).add(new Distance(string, new AtomSpec(0, "_CB_"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_N__"), new AtomSpec(0, "_C__"), new AtomSpec(0, "_CA_"), 1.53, 112.2, 103.0, 115.1, -120.7)).reqResName("PRO")).add(new Distance(string, new AtomSpec(0, "_CB_"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_N__"), new AtomSpec(0, "_C__"), new AtomSpec(0, "_CA_"), 1.54, 109.1, 111.5, 123.4, -122.0)).reqResName("/(VAL)|(THR)|(ILE)/")).add(new Distance(string, new AtomSpec(0, "_CB_"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_N__"), new AtomSpec(0, "_C__"), new AtomSpec(0, "_CA_"), 1.1, 109.3, 109.3, 121.6, -121.6)).reqResName("GLY")).add(new Distance(string, new AtomSpec(0, "_CB_"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_N__"), new AtomSpec(0, "_C__"), new AtomSpec(0, "_CA_"), 1.53, 110.1, 110.5, 122.8, -122.6)));
        }
        if ("hadev".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_HA_"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_N__"), new AtomSpec(0, "_C__"), new AtomSpec(0, "_CA_"), 1.1, 107.9, 108.1, -118.3, 118.2));
        }
        if ("nhdev".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_H__"), new XyzSpec.IdealTetrahedral(new AtomSpec(-1, "_C__"), new AtomSpec(0, "_CA_"), new AtomSpec(0, "_N__"), 1.0, 114.3, 123.9, 180.0, 180.0));
        }
        if ("codev".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_O__"), new XyzSpec.IdealTetrahedral(new AtomSpec(0, "_CA_"), new AtomSpec(1, "_N__"), new AtomSpec(0, "_C__"), 1.229, 122.7, 120.1, 180.0, 180.0));
        }
        if ("isprepro".equals(string)) {
            return new IsPrePro(string);
        }
        if ("alpha".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_O3*"), new AtomSpec(0, "_P__"), new AtomSpec(0, "_O5*"), new AtomSpec(0, "_C5*"));
        }
        if ("beta".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_P__"), new AtomSpec(0, "_O5*"), new AtomSpec(0, "_C5*"), new AtomSpec(0, "_C4*"));
        }
        if ("gamma".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_O5*"), new AtomSpec(0, "_C5*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"));
        }
        if ("delta".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C5*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_O3*"));
        }
        if ("epsilon".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_O3*"), new AtomSpec(1, "_P__"));
        }
        if ("zeta".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_O3*"), new AtomSpec(1, "_P__"), new AtomSpec(1, "_O5*"));
        }
        if ("eta".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_C4*"), new AtomSpec(0, "_P__"), new AtomSpec(0, "_C4*"), new AtomSpec(1, "_P__"));
        }
        if ("theta".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_P__"), new AtomSpec(0, "_C4*"), new AtomSpec(1, "_P__"), new AtomSpec(1, "_C4*"));
        }
        if ("chi".equals(string)) {
            return new Group(new Dihedral(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C5_"), new AtomSpec(0, "_C4_")).reqResName("/(FHU)|(PSU)|/")).add(new Dihedral(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_N9_"), new AtomSpec(0, "_C4_"))).add(new Dihedral(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_N1_"), new AtomSpec(0, "_C2_")));
        }
        if ("O5'-C5'".equals(string) || "O5'--C5'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_O5*"), new AtomSpec(0, "_C5*"));
        }
        if ("C5'-C4'".equals(string) || "C5'--C4'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_C5*"), new AtomSpec(0, "_C4*"));
        }
        if ("C4'-C3'".equals(string) || "C4'--C3'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"));
        }
        if ("C3'-C2'".equals(string) || "C3'--C2'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C2*"));
        }
        if ("C2'-C1'".equals(string) || "C2'--C1'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C1*"));
        }
        if ("O4'-C1'".equals(string) || "O4'--C1'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"));
        }
        if ("O4'-C4'".equals(string) || "O4'--C4'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C4*"));
        }
        if ("O3'-C3'".equals(string) || "O3'--C3'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_O3*"), new AtomSpec(0, "_C3*"));
        }
        if ("C2'-O2'".equals(string) || "C2'--O2'".equals(string)) {
            return new Distance(string, new AtomSpec(0, "_C2*"), new AtomSpec(0, "_O2*"));
        }
        if ("C3'-C4'-O4'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"));
        }
        if ("C4'-O4'-C1'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"));
        }
        if ("O4'-C1'-C2'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"));
        }
        if ("C1'-C2'-C3'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"));
        }
        if ("C4'-C3'-C2'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C2*"));
        }
        if ("C3'-C2'-C1'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C1*"));
        }
        if ("C2'-C1'-O4'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_O4*"));
        }
        if ("C1'-O4'-C4'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C1*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C4*"));
        }
        if ("O3'-C3'-C4'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_O3*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"));
        }
        if ("C3'-C4'-C5'".equals(string)) {
            return new Angle(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C5*"));
        }
        if ("C3'-C4'-O4'-C1'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"));
        }
        if ("C4'-O4'-C1'-C2'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"));
        }
        if ("O4'-C1'-C2'-C3'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"));
        }
        if ("C4'-C3'-C2'-C1'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C1*"));
        }
        if ("C3'-C2'-C1'-O4'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_O4*"));
        }
        if ("C2'-C1'-O4'-C4'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C4*"));
        }
        if ("O3'-C4'-C3'-C2'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_O3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C2*"));
        }
        if ("C5'-C3'-C4'-O4'".equals(string)) {
            return new Dihedral(string, new AtomSpec(0, "_C5*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"));
        }
        if ("alpha-1".equals(string)) {
            return new Dihedral(string, new AtomSpec(-2, "_O3*"), new AtomSpec(-1, "_P__"), new AtomSpec(-1, "_O5*"), new AtomSpec(-1, "_C5*"));
        }
        if ("beta-1".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_P__"), new AtomSpec(-1, "_O5*"), new AtomSpec(-1, "_C5*"), new AtomSpec(-1, "_C4*"));
        }
        if ("gamma-1".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_O5*"), new AtomSpec(-1, "_C5*"), new AtomSpec(-1, "_C4*"), new AtomSpec(-1, "_C3*"));
        }
        if ("delta-1".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_C5*"), new AtomSpec(-1, "_C4*"), new AtomSpec(-1, "_C3*"), new AtomSpec(-1, "_O3*"));
        }
        if ("epsilon-1".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_C4*"), new AtomSpec(-1, "_C3*"), new AtomSpec(-1, "_O3*"), new AtomSpec(0, "_P__"));
        }
        if ("zeta-1".equals(string)) {
            return new Dihedral(string, new AtomSpec(-1, "_C3*"), new AtomSpec(-1, "_O3*"), new AtomSpec(0, "_P__"), new AtomSpec(0, "_O5*"));
        }
        if ("chi-1".equals(string)) {
            return new Group(new Dihedral(string, new AtomSpec(-1, "_O4*"), new AtomSpec(-1, "_C1*"), new AtomSpec(-1, "_N9_"), new AtomSpec(-1, "_C4_"))).add(new Dihedral(string, new AtomSpec(-1, "_O4*"), new AtomSpec(-1, "_C1*"), new AtomSpec(-1, "_N1_"), new AtomSpec(-1, "_C2_")));
        }
        return null;
    }

    public static Measurement newDistance(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2) {
        return new Distance(string, xyzSpec, xyzSpec2);
    }

    public static Measurement newAngle(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2, XyzSpec xyzSpec3) {
        return new Angle(string, xyzSpec, xyzSpec2, xyzSpec3);
    }

    public static Measurement newDihedral(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2, XyzSpec xyzSpec3, XyzSpec xyzSpec4) {
        return new Dihedral(string, xyzSpec, xyzSpec2, xyzSpec3, xyzSpec4);
    }

    public static Measurement newVectorAngle(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2) {
        return new VectorAngle(string, xyzSpec, xyzSpec2);
    }

    public static Measurement newMaxB(String string, AtomSpec atomSpec) {
        return new MaxB(string, atomSpec);
    }

    public static Measurement newMinQ(String string, AtomSpec atomSpec) {
        return new MinQ(string, atomSpec);
    }

    public static class IsPrePro
    extends Measurement {
        public IsPrePro(String string) {
            super(string);
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Residue residue2 = residue.getNext(model);
            if (residue2 != null && residue2.getName().equals("PRO")) {
                return 1.0;
            }
            return 0.0;
        }

        protected String toStringImpl() {
            return this.getLabel();
        }

        public Object getType() {
            return TYPE_ISPREPRO;
        }
    }

    public static class Group
    extends Measurement {
        Collection group = new ArrayList();
        Object type;

        public Group(Measurement measurement) {
            super(measurement.getLabel());
            this.group.add(measurement);
            this.type = measurement.getType();
        }

        public Group add(Measurement measurement) {
            this.group.add(measurement);
            if (this.type != measurement.getType()) {
                this.type = TYPE_UNKNOWN;
            }
            return this;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            for (Measurement measurement : this.group) {
                double d = measurement.measure(model, modelState, residue);
                if (Double.isNaN(d)) continue;
                this.setMeanAndSigma(measurement.mean, measurement.sigma);
                return d;
            }
            return Double.NaN;
        }

        protected String toStringImpl() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.group.iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ; ");
                }
                stringBuffer.append(iterator.next());
            }
            return stringBuffer.toString();
        }

        public Object getType() {
            return this.type;
        }
    }

    public static class BasePhosPerp
    extends Measurement {
        public BasePhosPerp(String string) {
            super(string);
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            double d = Double.NaN;
            try {
                Residue residue2 = residue.getNext(model);
                if (residue2 != null) {
                    Atom atom = residue2.getAtom(" P  ");
                    Atom atom2 = residue.getAtom(" C1'");
                    Atom atom3 = residue.getAtom(" N9 ");
                    if (atom2 == null) {
                        atom2 = residue.getAtom(" C1*");
                    }
                    if (atom3 == null) {
                        atom3 = residue.getAtom(" N1 ");
                    }
                    AtomState atomState = modelState.get(atom);
                    AtomState atomState2 = modelState.get(atom2);
                    AtomState atomState3 = modelState.get(atom3);
                    Triple triple = new Triple().likeVector(atomState3, atomState);
                    Triple triple2 = new Triple().likeVector(atomState3, atomState2);
                    double d2 = triple.dot(triple2) / triple2.mag();
                    Triple triple3 = new Triple(triple2).unit().mult(d2);
                    Triple triple4 = new Triple().likeSum(atomState3, triple3);
                    d = Triple.distance(triple4, atomState);
                }
            }
            catch (AtomException atomException) {
                // empty catch block
            }
            return d;
        }

        protected String toStringImpl() {
            return this.getLabel();
        }

        public Object getType() {
            return TYPE_BASEPPERP;
        }
    }

    public static class PuckerAmp
    extends Measurement {
        Dihedral v0;
        Dihedral v1;
        Dihedral v2;
        Dihedral v3;
        Dihedral v4;
        double v0dbl;
        double v1dbl;
        double v2dbl;
        double v3dbl;
        double v4dbl;

        public PuckerAmp(String string) {
            super(string);
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            this.v0 = new Dihedral(this.label, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"));
            this.v1 = new Dihedral(this.label, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"));
            this.v2 = new Dihedral(this.label, new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"));
            this.v3 = new Dihedral(this.label, new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"));
            this.v4 = new Dihedral(this.label, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"));
            this.v0dbl = this.v0.measureImpl(model, modelState, residue);
            this.v1dbl = this.v1.measureImpl(model, modelState, residue);
            this.v2dbl = this.v2.measureImpl(model, modelState, residue);
            this.v3dbl = this.v3.measureImpl(model, modelState, residue);
            this.v4dbl = this.v4.measureImpl(model, modelState, residue);
            double d = this.v0dbl * this.v0dbl + this.v1dbl * this.v1dbl + this.v2dbl * this.v2dbl + this.v3dbl * this.v3dbl + this.v4dbl * this.v4dbl;
            double d2 = this.v0dbl * this.v1dbl + this.v1dbl * this.v2dbl + this.v2dbl * this.v3dbl + this.v3dbl * this.v4dbl + this.v4dbl * this.v0dbl;
            double d3 = this.v0dbl * this.v2dbl + this.v1dbl * this.v3dbl + this.v2dbl * this.v4dbl + this.v3dbl * this.v0dbl + this.v4dbl * this.v1dbl;
            double d4 = Math.pow(0.4, 2.0) * (d - (1.0 + Math.sqrt(5.0)) / 2.0 * d2 + (-1.0 + Math.sqrt(5.0)) / 2.0 * d3);
            double d5 = Math.sqrt(d4);
            return d5;
        }

        protected String toStringImpl() {
            StringBuffer stringBuffer = new StringBuffer("pucker " + this.getLabel());
            return stringBuffer.toString();
        }

        public Object getType() {
            return TYPE_PUCKER;
        }
    }

    public static class PuckerAng
    extends Measurement {
        Dihedral v0;
        Dihedral v1;
        Dihedral v2;
        Dihedral v3;
        Dihedral v4;
        double v0dbl;
        double v1dbl;
        double v2dbl;
        double v3dbl;
        double v4dbl;
        Collection<XyzSpec> specs = new ArrayList<XyzSpec>();

        public PuckerAng(String string) {
            super(string);
        }

        public PuckerAng add(XyzSpec xyzSpec) {
            this.specs.add(xyzSpec);
            return this;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            this.v0 = new Dihedral(this.label, new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"));
            this.v1 = new Dihedral(this.label, new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"));
            this.v2 = new Dihedral(this.label, new AtomSpec(0, "_C1*"), new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"));
            this.v3 = new Dihedral(this.label, new AtomSpec(0, "_C2*"), new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"));
            this.v4 = new Dihedral(this.label, new AtomSpec(0, "_C3*"), new AtomSpec(0, "_C4*"), new AtomSpec(0, "_O4*"), new AtomSpec(0, "_C1*"));
            this.v0dbl = this.v0.measureImpl(model, modelState, residue);
            this.v1dbl = this.v1.measureImpl(model, modelState, residue);
            this.v2dbl = this.v2.measureImpl(model, modelState, residue);
            this.v3dbl = this.v3.measureImpl(model, modelState, residue);
            this.v4dbl = this.v4.measureImpl(model, modelState, residue);
            double d = this.v4dbl + this.v1dbl - (this.v3dbl + this.v0dbl);
            double d2 = 2.0 * this.v2dbl * (Math.sin(0.6283185307179586) + Math.sin(1.2566370614359172));
            double d3 = Math.toDegrees(Math.atan(d / d2));
            if (this.v2dbl < 0.0 && !Double.isNaN(d3)) {
                return d3 + 180.0;
            }
            return d3;
        }

        protected String toStringImpl() {
            StringBuffer stringBuffer = new StringBuffer("pucker " + this.getLabel());
            return stringBuffer.toString();
        }

        public Object getType() {
            return TYPE_PUCKER;
        }
    }

    public static class Planarity
    extends Measurement {
        Collection<XyzSpec> specs = new ArrayList<XyzSpec>();

        public Planarity(String string) {
            super(string);
        }

        public Planarity add(XyzSpec xyzSpec) {
            this.specs.add(xyzSpec);
            return this;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Object object;
            double d = Math.cos(Math.toRadians(130.0));
            double d2 = Math.cos(Math.toRadians(25.0));
            long l = System.currentTimeMillis();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (XyzSpec tuple3Array2 : this.specs) {
                if (tuple3Array2 instanceof AtomSpec) {
                    object = ((AtomSpec)tuple3Array2).getAll(model, modelState, residue);
                    if (object.isEmpty()) {
                        return Double.NaN;
                    }
                    arrayList.addAll((Collection<Object>)object);
                    continue;
                }
                object = tuple3Array2.get(model, modelState, residue);
                if (object == null) {
                    return Double.NaN;
                }
                arrayList.add(object);
            }
            int n = arrayList.size();
            Tuple3[] tuple3Array = arrayList.toArray(new Tuple3[n]);
            object = new ArrayList();
            Triple triple = new Triple();
            Triple triple2 = new Triple();
            Triple triple3 = new Triple();
            for (int d6 = 0; d6 < n; ++d6) {
                for (int i = d6 + 1; i < n; ++i) {
                    for (int triple4 = i + 1; triple4 < n; ++triple4) {
                        triple.likeVector(tuple3Array[d6], tuple3Array[i]).unit();
                        triple2.likeVector(tuple3Array[i], tuple3Array[triple4]).unit();
                        triple3.likeVector(tuple3Array[triple4], tuple3Array[d6]).unit();
                        double triple5 = -triple.dot(triple2);
                        double triple6 = -triple2.dot(triple3);
                        double triple7 = -triple3.dot(triple);
                        if (triple5 < d || triple5 > d2 || triple6 < d || triple6 > d2 || triple7 < d || triple7 > d2) continue;
                        triple.likeCross(triple, triple2).unit();
                        object.add(new Normal(tuple3Array[d6], tuple3Array[i], tuple3Array[triple4], triple));
                    }
                }
            }
            double d3 = 1.0;
            Triple triple4 = null;
            Triple triple5 = null;
            Iterator d8 = object.iterator();
            while (d8.hasNext()) {
                Triple triple6 = (Triple)d8.next();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Triple triple7 = (Triple)iterator.next();
                    double d4 = Math.abs(triple6.dot(triple7));
                    if (!(d4 <= d3)) continue;
                    d3 = d4;
                    triple4 = triple6;
                    triple5 = triple7;
                }
            }
            double d5 = Math.toDegrees(Math.acos(d3));
            if (Double.isNaN(d5)) {
                d5 = d3 >= 0.0 ? 0.0 : 180.0;
            }
            return d5;
        }

        protected String toStringImpl() {
            StringBuffer stringBuffer = new StringBuffer("planarity " + this.getLabel() + " (");
            boolean bl = true;
            for (XyzSpec xyzSpec : this.specs) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(xyzSpec);
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public Object getType() {
            return TYPE_PLANARITY;
        }

        private static class Normal
        extends Triple {
            public Normal(Object object, Object object2, Object object3, Tuple3 tuple3) {
                super(tuple3);
            }

            public String toString() {
                return super.toString();
            }
        }
    }

    static class MinQ
    extends Measurement {
        AtomSpec a;

        public MinQ(String string, AtomSpec atomSpec) {
            super(string);
            this.a = atomSpec;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Collection collection = this.a.getAll(model, modelState, residue);
            if (collection.isEmpty()) {
                return Double.NaN;
            }
            double d = Double.POSITIVE_INFINITY;
            for (AtomState atomState : collection) {
                d = Math.min(d, atomState.getOccupancy());
            }
            return d;
        }

        protected String toStringImpl() {
            return "minq " + this.getLabel() + " " + this.a;
        }

        public Object getType() {
            return TYPE_MINQ;
        }
    }

    static class MaxB
    extends Measurement {
        AtomSpec a;

        public MaxB(String string, AtomSpec atomSpec) {
            super(string);
            this.a = atomSpec;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Collection collection = this.a.getAll(model, modelState, residue);
            if (collection.isEmpty()) {
                return Double.NaN;
            }
            double d = Double.NEGATIVE_INFINITY;
            for (AtomState atomState : collection) {
                d = Math.max(d, atomState.getTempFactor());
            }
            return d;
        }

        protected String toStringImpl() {
            return "maxb " + this.getLabel() + " " + this.a;
        }

        public Object getType() {
            return TYPE_MAXB;
        }
    }

    static class VectorAngle
    extends Measurement {
        XyzSpec a;
        XyzSpec b;

        public VectorAngle(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2) {
            super(string);
            this.a = xyzSpec;
            this.b = xyzSpec2;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Tuple3 tuple3 = this.a.get(model, modelState, residue);
            Tuple3 tuple32 = this.b.get(model, modelState, residue);
            if (tuple3 == null || tuple32 == null) {
                return Double.NaN;
            }
            double d = new Triple(tuple3).angle(tuple32);
            if (d > 90.0 && (this.a instanceof XyzSpec.Normal || this.b instanceof XyzSpec.Normal)) {
                d = 180.0 - d;
            }
            return d;
        }

        protected String toStringImpl() {
            return "vector_angle " + this.getLabel() + " " + this.a + ", " + this.b;
        }

        public Object getType() {
            return TYPE_V_ANGLE;
        }
    }

    static class Dihedral
    extends Measurement {
        XyzSpec a;
        XyzSpec b;
        XyzSpec c;
        XyzSpec d;

        public Dihedral(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2, XyzSpec xyzSpec3, XyzSpec xyzSpec4) {
            super(string);
            this.a = xyzSpec;
            this.b = xyzSpec2;
            this.c = xyzSpec3;
            this.d = xyzSpec4;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Tuple3 tuple3 = this.a.get(model, modelState, residue);
            Tuple3 tuple32 = this.b.get(model, modelState, residue);
            Tuple3 tuple33 = this.c.get(model, modelState, residue);
            Tuple3 tuple34 = this.d.get(model, modelState, residue);
            if (tuple3 == null || tuple32 == null || tuple33 == null || tuple34 == null) {
                return Double.NaN;
            }
            return Triple.dihedral(tuple3, tuple32, tuple33, tuple34);
        }

        protected String toStringImpl() {
            return "dihedral " + this.getLabel() + " " + this.a + ", " + this.b + ", " + this.c + ", " + this.d;
        }

        public Object getType() {
            return TYPE_DIHEDRAL;
        }

        public XyzSpec getA() {
            return this.a;
        }

        public XyzSpec getB() {
            return this.b;
        }

        public XyzSpec getC() {
            return this.c;
        }

        public XyzSpec getD() {
            return this.d;
        }
    }

    static class Angle
    extends Measurement {
        XyzSpec a;
        XyzSpec b;
        XyzSpec c;

        public Angle(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2, XyzSpec xyzSpec3) {
            super(string);
            this.a = xyzSpec;
            this.b = xyzSpec2;
            this.c = xyzSpec3;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Tuple3 tuple3 = this.a.get(model, modelState, residue);
            Tuple3 tuple32 = this.b.get(model, modelState, residue);
            Tuple3 tuple33 = this.c.get(model, modelState, residue);
            if (tuple3 == null || tuple32 == null || tuple33 == null) {
                return Double.NaN;
            }
            return Triple.angle(tuple3, tuple32, tuple33);
        }

        protected String toStringImpl() {
            return "angle " + this.getLabel() + " " + this.a + ", " + this.b + ", " + this.c;
        }

        public Object getType() {
            return TYPE_ANGLE;
        }

        public XyzSpec getA() {
            return this.a;
        }

        public XyzSpec getB() {
            return this.b;
        }

        public XyzSpec getC() {
            return this.c;
        }
    }

    static class Distance
    extends Measurement {
        XyzSpec a;
        XyzSpec b;

        public Distance(String string, XyzSpec xyzSpec, XyzSpec xyzSpec2) {
            super(string);
            this.a = xyzSpec;
            this.b = xyzSpec2;
        }

        protected double measureImpl(Model model, ModelState modelState, Residue residue) {
            Tuple3 tuple3 = this.a.get(model, modelState, residue);
            Tuple3 tuple32 = this.b.get(model, modelState, residue);
            if (tuple3 == null || tuple32 == null) {
                return Double.NaN;
            }
            return new Triple(tuple3).distance(tuple32);
        }

        protected String toStringImpl() {
            return "distance " + this.getLabel() + " " + this.a + ", " + this.b;
        }

        public Object getType() {
            return TYPE_DISTANCE;
        }

        public XyzSpec getA() {
            return this.a;
        }

        public XyzSpec getB() {
            return this.b;
        }
    }
}

