/*
 * Decompiled with CFR 0.152.
 */
package dangle;

import dangle.AtomSpec;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Disulfides;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResSpec {
    static final String ANY_RESNAME_PRINT = "";
    static final String ANY_RESNAME_REGEX = "/[_A-Za-z0-9]{3}/";
    String origResName;
    int resOffset;
    Matcher regexName;
    boolean requireCis;
    boolean requireDeoxy;
    boolean requireOxy;
    boolean require2p;
    boolean requireDisulf;

    public ResSpec(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        this.resOffset = n;
        this.requireCis = bl;
        this.requireDeoxy = bl2;
        this.requireOxy = bl3;
        this.require2p = bl4;
        this.requireDisulf = bl5;
        this.setResNames(string);
    }

    public ResSpec(String string) {
        this.resOffset = 0;
        this.requireCis = false;
        this.requireDeoxy = false;
        this.requireOxy = false;
        this.require2p = false;
        this.requireDisulf = false;
        this.setResNames(string);
    }

    public ResSpec() {
        this.resOffset = 0;
        this.requireCis = false;
        this.requireDeoxy = false;
        this.requireOxy = false;
        this.require2p = false;
        this.requireDisulf = false;
        this.setResNames(ANY_RESNAME_REGEX);
    }

    public void setResNames(String string) {
        this.origResName = string.equals(ANY_RESNAME_REGEX) ? ANY_RESNAME_PRINT : string;
        string = string.replace('_', ' ');
        this.regexName = string.startsWith("/") && string.endsWith("/") ? Pattern.compile(string.substring(1, string.length() - 1)).matcher(ANY_RESNAME_PRINT) : Pattern.compile(Pattern.quote(string)).matcher(ANY_RESNAME_PRINT);
    }

    public ResSpec requireCis() {
        this.requireCis = true;
        return this;
    }

    public ResSpec requireDeoxy() {
        this.requireDeoxy = true;
        return this;
    }

    public ResSpec requireOxy() {
        this.requireOxy = true;
        return this;
    }

    public ResSpec require2p() {
        this.require2p = true;
        return this;
    }

    public ResSpec requireDisulf() {
        this.requireDisulf = true;
        return this;
    }

    public boolean isMatch(Model model, ModelState modelState, Residue residue) {
        AtomSpec[] atomSpecArray;
        Object object;
        Object object2;
        if ((residue = this.getRes(model, modelState, residue, this.resOffset)) == null) {
            return false;
        }
        if (this.requireCis) {
            object2 = this.getRes(model, modelState, residue, -1);
            if (object2 == null) {
                return false;
            }
            try {
                object = modelState.get(((Residue)object2).getAtom(" CA "));
                atomSpecArray = modelState.get(((Residue)object2).getAtom(" C  "));
                AtomState atomState = modelState.get(residue.getAtom(" N  "));
                AtomSpec[] atomSpecArray2 = modelState.get(residue.getAtom(" CA "));
                double d = Triple.dihedral((Tuple3)object, (Tuple3)atomSpecArray, atomState, (Tuple3)atomSpecArray2);
                if (d < -90.0 || d > 90.0) {
                    return false;
                }
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        if (this.requireOxy || this.requireDeoxy) {
            object2 = new AtomSpec(0, "_C2*");
            object = ((AtomSpec)object2).get(model, modelState, residue);
            if (object == null) {
                return false;
            }
            atomSpecArray = new AtomSpec[]{new AtomSpec(0, " O2*"), new AtomSpec(0, "SE2*"), new AtomSpec(0, "_F__")};
            boolean bl = false;
            for (AtomSpec atomSpec : atomSpecArray) {
                double d;
                AtomState atomState = atomSpec.get(model, modelState, residue);
                if (atomState == null || Double.isNaN(d = Triple.distance((Tuple3)object, atomState)) || !(d < 2.0)) continue;
                bl = true;
                break;
            }
            if (this.requireOxy && !bl) {
                return false;
            }
            if (this.requireDeoxy && bl) {
                return false;
            }
        }
        if (this.require2p) {
            System.err.println("RNA 2'-pucker-specific bond lengths & angles not yet implemented!");
            return false;
        }
        if (this.requireDisulf) {
            object2 = model.getDisulfides();
            if (object2 == null) {
                return false;
            }
            object = ((Disulfides)object2).get(residue);
            if (object == null) {
                return false;
            }
        }
        return this.regexName.reset(residue.getName()).matches();
    }

    private Residue getRes(Model model, ModelState modelState, Residue residue, int n) {
        Residue residue2 = residue;
        int n2 = Math.abs(n);
        for (int i = 0; i < n2; ++i) {
            Residue residue3 = residue2;
            residue2 = n > 0 ? residue.getNext(model) : residue.getPrev(model);
            if (residue2 == null) {
                return null;
            }
            if (!(n > 0 ? !this.checkConnection(model, modelState, residue3, residue2) : !this.checkConnection(model, modelState, residue2, residue3))) continue;
            return null;
        }
        return residue2;
    }

    private boolean checkConnection(Model model, ModelState modelState, Residue residue, Residue residue2) {
        Atom atom = null;
        Atom atom2 = null;
        Atom atom3 = null;
        Atom atom4 = null;
        atom = residue.getAtom(" C  ");
        atom2 = residue2.getAtom(" N  ");
        if (atom != null && atom2 != null) {
            try {
                AtomState atomState = modelState.get(atom);
                AtomState atomState2 = modelState.get(atom2);
                return atomState.sqDistance(atomState2) <= 4.0;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        atom3 = residue.getAtom(" O3*");
        if (atom3 == null) {
            atom3 = residue.getAtom(" O3'");
        }
        atom4 = residue2.getAtom(" P  ");
        if (atom3 != null && atom4 != null) {
            try {
                AtomState atomState = modelState.get(atom3);
                AtomState atomState3 = modelState.get(atom4);
                return atomState.sqDistance(atomState3) <= 4.84;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return "for" + (this.requireCis ? " cis" : ANY_RESNAME_PRINT) + (this.requireDeoxy ? " deoxy" : ANY_RESNAME_PRINT) + (this.requireOxy ? " oxy" : ANY_RESNAME_PRINT) + (this.require2p ? " 2'" : ANY_RESNAME_PRINT) + (this.requireDisulf ? " disulf" : ANY_RESNAME_PRINT) + (this.origResName.equals(ANY_RESNAME_PRINT) ? ANY_RESNAME_PRINT : " " + this.origResName);
    }
}

