/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neighborhood {
    Residue cen;
    Model model;
    double dist = Double.NaN;
    int nPrev = -1;
    int nNext = -1;

    public Neighborhood(Residue residue, Model model, int n, int n2) throws NullPointerException {
        if (residue == null) {
            throw new NullPointerException("Must provide a non-null residue");
        }
        if (model == null) {
            throw new NullPointerException("Must provide a non-null model");
        }
        this.cen = residue;
        this.model = model;
        this.nPrev = n;
        this.nNext = n2;
    }

    public Neighborhood(Residue residue, Model model, double d) throws NullPointerException {
        if (residue == null) {
            throw new NullPointerException("Must provide a non-null residue");
        }
        if (model == null) {
            throw new NullPointerException("Must provide a non-null model");
        }
        this.cen = residue;
        this.model = model;
        this.dist = d;
    }

    public ArrayList<Residue> getMembers() {
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        for (Residue residue : this.model.getResidues()) {
            int n;
            if (!Double.isNaN(this.dist)) {
                try {
                    if (!Neighborhood.areWithin(residue, this.cen, this.model, this.dist)) continue;
                    arrayList.add(residue);
                }
                catch (AtomException atomException) {
                    System.err.println("error determining if " + residue + " is within " + this.dist + "A of " + this.cen);
                }
                continue;
            }
            if (this.nPrev == -1 || this.nNext == -1 || (n = Math.abs(residue.getSequenceInteger() - this.cen.getSequenceInteger())) > this.nPrev || n > this.nNext) continue;
            arrayList.add(residue);
        }
        return arrayList;
    }

    public static boolean areWithin(Residue residue, Residue residue2, Model model, double d) throws AtomException {
        ModelState modelState = model.getState();
        Iterator iterator = residue.getAtoms().iterator();
        while (iterator.hasNext()) {
            AtomState atomState = modelState.get((Atom)iterator.next());
            Iterator iterator2 = residue2.getAtoms().iterator();
            while (iterator2.hasNext()) {
                AtomState atomState2 = modelState.get((Atom)iterator2.next());
                if (!(atomState.distance(atomState2) < d)) continue;
                return true;
            }
        }
        return false;
    }
}

