/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.SecondaryStructure;
import java.util.Collection;

class PdbSecondaryStructure
extends SecondaryStructure {
    public PdbSecondaryStructure(Collection collection) {
        for (String string : collection) {
            try {
                if (string.startsWith("HELIX ")) {
                    this.addRange(this.forHelix(string));
                    continue;
                }
                if (string.startsWith("SHEET ")) {
                    this.addRange(this.forSheet(string));
                    continue;
                }
                if (!string.startsWith("TURN  ")) continue;
                this.addRange(this.forTurn(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Non-numeric sequence numbers: " + string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.err.println("PDB record too short: " + string);
            }
        }
    }

    SecondaryStructure.Range forHelix(String string) throws NumberFormatException {
        SecondaryStructure.Range range = new SecondaryStructure.Range();
        range.type = HELIX;
        range.chainId = string.substring(19, 20);
        if (!range.chainId.equals(string.substring(31, 32))) {
            System.err.println("Mismatched chain IDs: " + string);
        }
        range.initSeqNum = Integer.parseInt(string.substring(21, 25).trim());
        range.endSeqNum = Integer.parseInt(string.substring(33, 37).trim());
        range.initICode = string.substring(25, 26);
        if (string.length() >= 38) {
            range.endICode = string.substring(37, 38);
        }
        return range;
    }

    SecondaryStructure.Range forSheet(String string) throws NumberFormatException {
        SecondaryStructure.Range range = new SecondaryStructure.Range();
        range.type = STRAND;
        range.chainId = string.substring(21, 22);
        if (!range.chainId.equals(string.substring(32, 33))) {
            System.err.println("Mismatched chain IDs: " + string);
        }
        range.initSeqNum = Integer.parseInt(string.substring(22, 26).trim());
        range.endSeqNum = Integer.parseInt(string.substring(33, 37).trim());
        range.initICode = string.substring(26, 27);
        if (string.length() >= 38) {
            range.endICode = string.substring(37, 38);
        }
        range.sense = Integer.parseInt(string.substring(38, 40).trim());
        range.strand = Integer.parseInt(string.substring(7, 10).trim());
        range.sheetID = string.substring(11, 14);
        return range;
    }

    SecondaryStructure.Range forTurn(String string) throws NumberFormatException {
        SecondaryStructure.Range range = new SecondaryStructure.Range();
        range.type = TURN;
        range.chainId = string.substring(19, 20);
        if (!range.chainId.equals(string.substring(30, 31))) {
            System.err.println("Mismatched chain IDs: " + string);
        }
        range.initSeqNum = Integer.parseInt(string.substring(20, 24).trim());
        range.endSeqNum = Integer.parseInt(string.substring(31, 35).trim());
        range.initICode = string.substring(24, 25);
        if (string.length() >= 36) {
            range.endICode = string.substring(35, 36);
        }
        return range;
    }
}

