/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.data.UberMap;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Hy36;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Residue
implements Comparable {
    public static final int NAN_SEQ = Integer.MAX_VALUE;
    String chain = "  ";
    String segment = "";
    Map atoms;
    Collection unmodAtoms = null;
    String seqNum;
    int seqInt;
    String insCode;
    String resName;
    String qnameCache = null;
    int modCount = 0;
    public int sectionID = 0;

    public Residue(String string, String string2, String string3, String string4, String string5) {
        if (string == null) {
            throw new IllegalArgumentException("Must provide a non-null chain ID");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide a non-null segment ID");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Must provide a non-null sequence number/ID");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("Must provide a non-null insertion code");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("Must provide a non-null residue name");
        }
        if (string.equals("  ") && !string2.trim().equals("")) {
            this.chain = string2;
            this.segment = "";
        } else {
            this.chain = string;
            this.segment = string2;
        }
        this.seqNum = string3;
        this.insCode = string4;
        this.resName = string5;
        try {
            this.seqInt = Integer.parseInt(this.seqNum.trim());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.seqInt = Hy36.decode(4, string3);
            }
            catch (Error error) {
                this.seqInt = Integer.MAX_VALUE;
            }
        }
        this.atoms = new UberMap();
    }

    public Residue(Residue residue, String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, string5);
        try {
            Iterator iterator = residue.getAtoms().iterator();
            while (iterator.hasNext()) {
                this.add(new Atom((Atom)iterator.next()));
            }
        }
        catch (AtomException atomException) {
            System.err.println("Unable to duplicate residue?");
            atomException.printStackTrace();
        }
    }

    public Residue(Residue residue) {
        this(residue.getChain(), residue.getSegment(), residue.getSequenceNumber(), residue.getInsertionCode(), residue.getName());
    }

    public ModelState cloneStates(Residue residue, ModelState modelState, ModelState modelState2) throws AtomException {
        for (Atom atom : this.getAtoms()) {
            Atom atom2 = residue.getAtom(atom.getName());
            if (atom2 == null) continue;
            modelState2.add(modelState.get(atom2).cloneFor(atom));
        }
        return modelState2;
    }

    public String getChain() {
        return this.chain;
    }

    public String getSegment() {
        return this.segment;
    }

    public Collection getAtoms() {
        if (this.unmodAtoms == null) {
            this.unmodAtoms = Collections.unmodifiableCollection(this.atoms.values());
        }
        return this.unmodAtoms;
    }

    public Atom getAtom(String string) {
        return (Atom)this.atoms.get(string);
    }

    public String getSequenceNumber() {
        return this.seqNum;
    }

    public int getSequenceInteger() {
        return this.seqInt;
    }

    public String getInsertionCode() {
        return this.insCode;
    }

    public String getName() {
        return this.resName;
    }

    public String getCNIT() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.getChain().length() > 0 ? this.getChain() : "  ");
        stringBuffer.append(Strings.justifyRight(this.getSequenceNumber(), 4));
        stringBuffer.append(this.getInsertionCode().length() > 0 ? this.getInsertionCode().substring(0, 1) : " ");
        stringBuffer.append(Strings.justifyLeft(this.getName(), 3));
        return stringBuffer.toString();
    }

    public Residue getNext(Model model) {
        if (model == null) {
            return null;
        }
        try {
            Residue residue = (Residue)model.residues.itemAfter(this);
            if (!residue.getChain().equals(this.getChain())) {
                return null;
            }
            return residue;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Residue getPrev(Model model) {
        if (model == null) {
            return null;
        }
        try {
            Residue residue = (Residue)model.residues.itemBefore(this);
            if (!residue.getChain().equals(this.getChain())) {
                return null;
            }
            return residue;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public void add(Atom atom) throws AtomException {
        String string = atom.getName();
        if (this.atoms.containsKey(string)) {
            throw new AtomException("An atom named " + string + " is already part of " + this);
        }
        if (atom.parent != null) {
            atom.parent.remove(atom);
        }
        this.atoms.put(string, atom);
        atom.parent = this;
        this.modified();
    }

    public void remove(Atom atom) throws AtomException {
        String string = atom.getName();
        Atom atom2 = (Atom)this.atoms.get(string);
        if (!atom.equals(atom2)) {
            throw new AtomException(atom + " is not part of " + this);
        }
        this.atoms.remove(string);
        atom.parent = null;
        this.modified();
    }

    protected void modified() {
        ++this.modCount;
    }

    public int getModCount() {
        return this.modCount;
    }

    public String nickname() {
        return this.getName().trim().substring(0, 1).toUpperCase() + this.getName().trim().substring(1).toLowerCase() + this.getSequenceNumber().trim() + this.getInsertionCode().trim();
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        Residue residue = this;
        Residue residue2 = (Residue)object;
        int n = residue.chain.compareTo(residue2.chain);
        if (n != 0) {
            return n;
        }
        n = residue.segment.compareTo(residue2.segment);
        if (n != 0) {
            return n;
        }
        n = residue.seqInt - residue2.seqInt;
        if (n != 0) {
            return n;
        }
        n = residue.seqNum.compareTo(residue2.seqNum);
        if (n != 0) {
            return n;
        }
        n = residue.insCode.compareTo(residue2.insCode);
        if (n != 0) {
            return n;
        }
        n = residue.resName.compareTo(residue2.resName);
        if (n != 0) {
            return n;
        }
        return System.identityHashCode(residue) - System.identityHashCode(residue2);
    }

    public String toString() {
        if (this.qnameCache == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.chain);
            stringBuffer.append(this.seqNum);
            String string = this.insCode.trim();
            if (string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.resName);
            this.qnameCache = stringBuffer.toString();
        }
        return this.qnameCache;
    }
}

