/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2.selection;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.SecondaryStructure;
import driftwood.moldb2.Selection;
import java.util.Collection;

public class SecondaryStructureTerm
extends Selection {
    String secStrucType;
    CoordinateFile coordFile;

    public SecondaryStructureTerm(String string) {
        this.secStrucType = string;
    }

    public void init(Collection collection, CoordinateFile coordinateFile) {
        super.init(collection, coordinateFile);
        this.coordFile = coordinateFile;
    }

    protected boolean selectImpl(AtomState atomState) {
        SecondaryStructure secondaryStructure = this.coordFile.getSecondaryStructure();
        if (this.secStrucType.equals("alpha") && secondaryStructure.isHelix(atomState.getResidue())) {
            return true;
        }
        return this.secStrucType.equals("beta") && secondaryStructure.isStrand(atomState.getResidue());
    }

    public String toString() {
        return this.secStrucType;
    }
}

