/*
 * Decompiled with CFR 0.152.
 */
package driftwood.util;

import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;

public class SoftOutputStream
extends OutputStream {
    Collection strings;
    byte[] buffer;
    int bufcount;
    final int bufsize;

    public SoftOutputStream() {
        this(64);
    }

    public SoftOutputStream(int n) {
        this.bufsize = n * 1024;
        this.bufcount = 0;
        this.buffer = new byte[this.bufsize];
        this.strings = new ArrayList();
    }

    public void close() {
    }

    public synchronized void flush() {
        if (this.bufcount > 0) {
            String string = new String(this.buffer, 0, this.bufcount);
            this.strings.add(new SoftReference<String>(string));
            this.bufcount = 0;
        }
    }

    public synchronized void write(int n) {
        if (this.bufcount == this.bufsize) {
            this.flush();
        }
        this.buffer[this.bufcount++] = (byte)n;
    }

    public synchronized void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = Math.min(n2, this.bufsize - this.bufcount);
            System.arraycopy(byArray, n, this.buffer, this.bufcount, n3);
            n += n3;
            n2 -= n3;
            this.bufcount += n3;
            if (this.bufcount != this.bufsize) continue;
            this.flush();
        }
    }

    public synchronized String getString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        for (SoftReference softReference : this.strings) {
            string = (String)softReference.get();
            if (string == null) {
                string = "\n[*** Content lost due to low memory ***]\n";
            }
            stringBuffer.append(string);
        }
        string = new String(this.buffer, 0, this.bufcount);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public synchronized void clear() {
        this.strings.clear();
        this.bufcount = 0;
    }
}

